<!DOCTYPE html>
<html dir="rtl" lang="ar">

<head>
    <meta charset="UTF-8">
    <title>امر دفع - {{ $client->arabic_name }}</title>
    <style>
        @page {
            size: A4;
            margin: 0;
        }

        body {
            font-family: 'Arial', sans-serif;
            margin: 0;
            padding: 20px;
            direction: rtl;
            line-height: 1.6;
        }

        .container {
            border: 2px solid #000;
            padding: 30px;
            min-height: 260mm;
            position: relative;
            box-sizing: border-box;
        }

        .header {
            display: flex;
            justify-content: space-between;
            align-items: flex-start;
            margin-bottom: 30px;
            border-bottom: 1px solid #eee;
            padding-bottom: 15px;
        }

        .logo {
            width: 120px;
        }

        .title {
            text-align: center;
            font-size: 26px;
            font-weight: bold;
            text-decoration: underline;
            margin-bottom: 40px;
        }

        .info-section {
            margin-bottom: 25px;
            font-size: 16px;
        }

        .label {
            font-weight: bold;
            min-width: 140px;
            display: inline-block;
            color: #333;
        }

        .amount-box {
            border: 2px solid #000;
            padding: 12px 20px;
            font-size: 24px;
            font-weight: bold;
            display: inline-block;
            background: #fff;
            margin-left: 10px;
        }

        .qr-code {
            position: absolute;
            top: 120px;
            left: 40px;
            text-align: center;
        }

        .footer {
            margin-top: 60px;
            display: flex;
            justify-content: space-between;
            padding: 0 20px;
        }

        .signature {
            text-align: center;
            min-width: 180px;
        }

        .footer-note {
            position: absolute;
            bottom: 30px;
            right: 30px;
            left: 30px;
            font-size: 13px;
            border-top: 2px solid #000;
            padding-top: 15px;
            line-height: 1.8;
        }
    </style>
</head>

<body>
    <div class="container">
        <div class="header">
            <div>
                <img src="{{ asset('images/logo.png') }}" class="logo">
                <div style="font-weight: bold; margin-top: 10px;">جمعية تيباروز التعاونية</div>
                <div>للاسكان والبناء</div>
            </div>
            <div style="text-align: left;">
                <div>تاريخ الإصدار: {{ now()->format('Y-m-d') }}</div>
                <div>صالح حتى:
                    {{ \Carbon\Carbon::parse($order->issue_date)->addDays($order->pay_until)->format('Y-m-d') }}
                </div>
            </div>
        </div>

        <div class="title">إذن توريد لخزينة البنك</div>

        <div class="qr-code">
            <!-- Legacy QR logic would go here, currently using a placeholder or simple div -->
            <div style="border: 1px solid #ddd; padding: 10px; font-size: 10px; text-align: center;">
                QR-ORDER-{{ $order->id }}
            </div>
        </div>

        <div class="info-section">
            <p><span class="label">السيد /</span> <span
                    style="font-size: 18px; font-weight: bold;">{{ $client->arabic_name }}</span></p>
            <p><span class="label">رقم العضوية:</span> {{ $client->member_no }}</p>
            <p><span class="label">المشروع:</span> {{ $order->project->name ?? 'N/A' }}</p>
            <p><span class="label">توصيف الوحدة:</span> العقار رقم ({{ $reservation->bldg_id ?? '' }}) - الدور
                ({{ $reservation->floor ?? '' }}) - رقم الوحدة ({{ $reservation->flat_num ?? '' }})</p>
        </div>

        <div class="info-section" style="background: #f9f9f9; padding: 15px; border-radius: 8px;">
            <p>برجاء التكرم بقبول توريد مبلغ وقدره :</p>
            <div style="display: flex; align-items: center; gap: 20px; margin: 15px 0;">
                <div class="amount-box">{{ number_format($order->amount, 2) }} ج.م</div>
                <div style="font-weight: bold;">( {{ $amount_in_words }} )</div>
            </div>
            <p><span class="label">وذلك قيمة :</span> {{ $order->type }}</p>
        </div>

        <div class="info-section">
            <p>يتم التوريد بـ : ( {{ $bank_name }} )</p>
            <p><span class="label">حساب رقم :</span> <span
                    style="font-family: monospace; font-size: 18px; letter-spacing: 1px;">{{ $bank_account }}</span></p>
        </div>

        <div class="footer">
            <div class="signature">
                <p>اللجنة الفرعية</p>
                <div style="height: 60px;"></div>
                <p>..........................</p>
            </div>
            <div class="signature">
                <p>المراجع الجاري</p>
                <div style="height: 60px;"></div>
                <p>..........................</p>
            </div>
            <div class="signature">
                <p>يعتمد ،،،</p>
                <div style="height: 60px;"></div>
                <p>مدير الإدارة المالية</p>
            </div>
        </div>

        <div class="footer-note">
            * تنبيه: هذا الإذن صالح فقط لمدة ({{ $order->pay_until }}) يوماً من تاريخ إصداره، ولا يعتد به بعد ذلك.
            <br>
            * لا يعتد بهذا الإذن إلا بعد توريد المبلغ في البنك المذكور عاليه.
        </div>
    </div>
</body>

</html>