<!DOCTYPE html>
<html dir="rtl" lang="ar">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>{{ __('Payment Statement') }} - {{ $client->arabic_name }}</title>
    <style>
        @page {
            size: A4;
            margin: 10mm 15mm;
        }

        body {
            direction: rtl;
            font-family: 'Arial', sans-serif;
            margin: 0 auto;
            padding: 15px;
            background-color: #fff;
            max-width: 190mm;
            box-sizing: border-box;
        }

        .info tr,
        .info tr th,
        .info tr td,
        .rec_info_table tr,
        .rec_info_table tr th,
        .rec_info_table tr td {
            border: 1px solid #cc0000;
            text-align: center;
            padding: 4px 6px;
            font-size: 11px;
        }

        .info,
        .rec_info_table {
            width: 100%;
            border-collapse: collapse;
            margin-bottom: 15px;
            table-layout: fixed;
        }

        .info {
            max-height: 33vh;
            font-size: 11px;
        }

        .info tr th,
        .rec_info_table tr th {
            background-color: #ebebe0 !important;
            color: #0033cc;
            font-weight: bold;
            padding: 4px 6px;
        }

        .info tr td {
            padding: 3px 6px;
        }

        .head {
            width: 86%;
            text-align: center;
            font-size: 22px;
            font-weight: bold;
            float: left;
            margin-bottom: 8px;
        }

        .prn {
            float: left;
            margin-left: 12%;
            margin-top: 1%;
        }

        .section-title {
            background-color: #ebebe0;
            text-align: center;
            font-size: 18px;
            color: #0033cc;
            width: 50%;
            margin: 12px auto !important;
            padding: 6px;
            font-weight: bold;
        }

        hr {
            color: #cc0000;
            background-color: #cc0000;
            height: 3px;
            width: 100%;
            border: none;
            margin: 8px 0;
        }

        .logo {
            width: 12%;
            float: right;
        }

        @media print {

            .prn,
            .no-print,
            .hid {
                display: none !important;
            }

            body {
                background-color: white !important;
                padding: 0 !important;
                margin: 0 auto !important;
                max-width: 100% !important;
                width: 100% !important;
            }

            @page {
                size: A4;
                margin: 10mm 15mm;
            }

            /* Prevent table footer from repeating on each page */
            .rec_info_table tfoot {
                display: table-footer-group;
            }

            .rec_info_table tfoot tr {
                break-inside: avoid;
            }
        }
    </style>
</head>

<body>
    {{-- Print Button --}}
    <button type="button" class="prn no-print" onclick="window.print()"
        style="padding: 8px 16px; background-color: #f0f0f0; border: 1px solid #ccc; cursor: pointer; border-radius: 4px;">
        <i class="fa fa-print"></i> طباعه
    </button>

    {{-- Logo --}}
    <img src="/admin_laravel/public/assets/images/logo.png" class="logo" alt="Logo" />

    <br /><br />

    {{-- Header --}}
    <div class="head" style="margin-top:25px !important">
        جمعيه تيباروز لاسكان ضباط الدفاع الجوى<br />
        بيان مدفوعات {{ $client->arabic_name }}
    </div>
    <div style="width:100%;float:left"></div>
    <hr />

    @if(!$reservation)
        <div style="margin: 50px auto; padding: 30px; border: 2px dashed #cc0000; text-align: center; width: 80%; background-color: #fff5f5; border-radius: 8px;">
            <h2 style="color: #cc0000; margin-bottom: 10px;">{{ __('No Reservation Found') }}</h2>
            <p style="font-size: 18px; color: #666;">لا يوجد تخصيص لهذا العضو حالياً</p>
        </div>
    @else

    <br />
    {{-- Member Information Section --}}
    <div class="section-title">بيانات العضو</div>
    <br />
    <table class="info">
        <tr>
            <th>الاسم</th>
            <td>{{ $client->arabic_name }}</td>
            <th style="background-color:#d6d6c2 !important">المستحق دفعه من سعر الجراج</th>
            <td>{{ $priceData['park_required'] ?? 0 }}</td>
        </tr>
        <tr>
            <th>رقم العضويه</th>
            <td>{{ $client->old_member_no }}</td>
            <th style="background-color:#d6d6c2 !important">أجمالى المدفوع للجراج</th>
            <td>{{ intval($priceData['park_total'] ?? 0) }}</td>
        </tr>
        <tr>
            <th>رقم الملف</th>
            <td>{{ $client->file_no }}</td>
            <th style="background-color:#d6d6c2 !important">متاخرات من اقساط الجراج</th>
            @php
                $park_remain = ($priceData['park_required'] ?? 0) - intval($priceData['park_total'] ?? 0);
                $park_bg = $park_remain > 0 ? '#F00' : '#53c653';
                // If required > paid, show positive Arrears value (Amount Due).
                // Or if we follow legacy exactly: ($park_required - intval($money['park_total']))
                // If 1000 - 500 = 500 (Positive arrears, means owe money) -> Red
                // If 500 - 1000 = -500 (Overpaid) -> Green
                $display_park = $park_remain < 0 ? abs($park_remain) : $park_remain;
            @endphp
            <td style="background-color:{{ $park_bg }} !important; color: white;">
                {{ $display_park }}
            </td>
        </tr>
        <tr>
            <th>المشروع</th>
            <td>{{ $reservation->project_name ?? '-' }}</td>
            <th style="background-color:#ffb84d !important">المستحق دفعه من سعر الروف</th>
            <td>0</td>
        </tr>
        <tr>
            <th>المساحه</th>
            <td>{{ $reservation->flat_txt ?? '-' }} - {{ $sessArr[$reservation->sess ?? '1'] ?? '' }} ({{ $subsess }})</td>
            <th style="background-color:#ffb84d !important">اجمالى المدفوع للروف</th>
            <td>0</td>
        </tr>
        <tr>
            <th>التخصيص</th>
            <td>{{ $reservation->bldg_id ?? '-' }} -- {{ $reservation->flat_num ?? '-' }}</td>
            <th style="background-color:#ffb84d !important">متاخرات من اقساط الروف</th>
            <td style="background-color:#53c653 !important">0</td>
        </tr>
        <tr>
            <th>المستحق غرامات / فوائد</th>
            <td>0</td>
            <th style="background-color:#ffb84d !important">اجمالى المدفوع للغاز</th>
            <td>0</td>
        </tr>
        <tr>
            <th>أجمالى سعر الوحده شبه تقديرى</th>
            <td>{{ intval($priceData['flat_aprox_total'] ?? 0) }}</td>
            <th style="background-color:#53c653 !important">مساحه الحديقه</th>
            <td>{{ $priceData['garden_size'] ?? 0 }}</td>
        </tr>
        <tr>
            <th>المستحق دفعه للوحده</th>
            <td>{{ intval($priceData['biggest_total'] ?? 0) }}</td>
            <th style="background-color:#53c653 !important">المستحق دفعه من سعر الحديقه</th>
            <td>{{ $priceData['late_gard_total'] ?? 0 }}</td>
        </tr>
        <tr>
            <th>اجمالى المدفوعات للوحده</th>
            <td>{{ intval($priceData['total'] ?? 0) - intval($priceData['park_total'] ?? 0) }}</td>
            <th style="background-color:#53c653 !important">اجمالى المدفوع للحديقه</th>
            <td>{{ $priceData['gard_rem'] ?? 0 }}</td>
        </tr>
        <tr>
            <th>المتبقي</th>
            <td style="background-color:#fff !important">
                {{ number_format(abs($priceData['remain'] ?? 0), 2) }}
            </td>
            <th style="background-color:#53c653 !important">متاخرات من اقساط الحديقه</th>
            @php
                 // Arrears = Paid - Due (Until Now)
                 // If Paid 500 - Due 1000 = -500 (Arrears/Late) -> Red
                 // Using late_gard_total as "Due" per user request
                 $gard_diff = ($priceData['gard_rem'] ?? 0) - ($priceData['late_gard_total'] ?? 0);
                 $gard_bg = $gard_diff < 0 ? '#F00' : '#53c653'; 
            @endphp
            <td style="background-color:{{ $gard_bg }} !important; color: white;">
                {{ $gard_diff }}
            </td>
        </tr>
        <tr>
            <th>تم الطباعه بواسطه</th>
            <td>{{ auth()->user()->name ?? 'Admin' }}</td>
            <th>توقيت الطبع</th>
            <td>{{ now()->format('d-M-Y h:i:s') }}</td>
        </tr>
    </table>

    @if($parking->isNotEmpty())
        <br />
        {{-- Parking Assignment Section --}}
        <div class="section-title">تخصيص الجراج</div>
        <br />
        <table class="rec_info_table">
            <thead>
                <tr>
                    <th>رقم العماره</th>
                    <th>رقم الباكيه</th>
                </tr>
            </thead>
            <tbody>
                @foreach($parking as $park)
                    <tr>
                        <td>{{ $park->bldg }}</td>
                        <td>{{ $park->park_no }}</td>
                    </tr>
                @endforeach
            </tbody>
        </table>
    @endif

    <br />
    {{-- Unit Payments Section --}}
    <div class="section-title">مدفوعات الوحده</div>
    <br />
    <table class="rec_info_table" style="font-size: 11px;">
        <thead>
            <tr>
                <th style="width: 5%;">مسلسل</th>
                <th style="width: 22%;">رقم الايصال/الشيك</th>
                <th style="width: 15%;">رقم الايصال البنكى</th>
                <th style="width: 12%;">قيمه الايصال/الشيك</th>
                <th style="width: 15%;">تاريخ الايصال/الشيك</th>
                <th style="width: 13%;">نوع الايصال</th>
                <th style="width: 10%;">تسويه ماليه</th>
                <th class="hid" style="width: 8%;">مراجعه</th>
            </tr>
        </thead>
        <tbody>
            @php $serial = 1;
            $total = 0; @endphp
        @foreach($receipts as $receipt)
            @if($receipt->chk != 'Y')
                <tr class="row_{{ $receipt->id }}" style="{{ $receipt->rev == 'Y' ? 'background-color: yellow;' : '' }}">
                    <td style="{{ $receipt->rev == 'Y' ? 'background-color: yellow;' : '' }}">{{ $serial++ }}</td>
                    <td style="{{ $receipt->rev == 'Y' ? 'background-color: yellow;' : '' }}">{{ $receipt->number }}</td>
                    <td style="{{ $receipt->rev == 'Y' ? 'background-color: yellow;' : '' }}">{{ $receipt->bnk_number }}</td>
                    <td style="{{ $receipt->rev == 'Y' ? 'background-color: yellow;' : '' }}">{{ number_format($receipt->value) }}</td>
                    <td style="{{ $receipt->rev == 'Y' ? 'background-color: yellow;' : '' }}">{{ $receipt->date }}</td>
                    <td style="{{ $receipt->rev == 'Y' ? 'background-color: yellow;' : '' }}">{{ $receipt->type_txt ?? '-' }}</td>
                    <td style="{{ $receipt->rev == 'Y' ? 'background-color: yellow;' : '' }}">{{ $receipt->penality ?? '0' }}</td>
                    <td class="hid" style="{{ $receipt->rev == 'Y' ? 'background-color: yellow;' : '' }}">
                        <input type="checkbox" class="rev-chk" data-id="{{ $receipt->id }}" {{ $receipt->rev == 'Y' ? 'checked' : '' }}>
                    </td>
                </tr>
                    @php $total += $receipt->value; @endphp
            @endif
        @endforeach
        </tbody>
        <tfoot>
            <tr>
                <th colspan="3" style="font-weight:bold">ألاجمالى</th>
                <td colspan="5" style="font-weight:bold">{{ number_format($total) }}</td>
            </tr>
        </tfoot>
    </table>

    <br /><br />
    {{-- Grand Total Section --}}
    <div class="section-title">أجمالى عام</div>
    <br />
    <table class="rec_info_table">
        <tr>
            <th colspan="2">البند</th>
            <th colspan="2">أجمالى</th>
        </tr>
        <tr>
            <th colspan="2">أجمالى المستحق</th>
            <td colspan="2">{{ number_format($priceData['biggest_total'] ?? 0) }}</td>
        </tr>
        <tr>
            <th colspan="2">أجمالى المدفوع</th>
            <td colspan="2">{{ number_format($totalPaid) }}</td>
        </tr>
        <tr>
            <th colspan="2">أجمالى الأستكمال</th>
            <td style="background-color:#53c653" colspan="2">
                {{ number_format(($priceData['biggest_total'] ?? 0) - $totalPaid) }}
            </td>
        </tr>
    </table>

    @endif

    <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
    <script>
        $(document).ready(function() {
            $('.rev-chk').on('change', function() {
                const id = $(this).data('id');
                const stat = this.checked ? 'Y' : 'N';
                const row = $('.row_' + id);
                const cells = row.find('td');

                $.ajax({
                    url: '{{ route('clients.toggle_review') }}',
                    type: 'POST',
                    data: {
                        id: id,
                        stat: stat,
                        _token: '{{ csrf_token() }}'
                    },
                    success: function(response) {
                        if (response.success) {
                            if (stat === 'Y') {
                                row.css('background-color', 'yellow');
                                cells.css('background-color', 'yellow');
                            } else {
                                row.css('background-color', '');
                                cells.css('background-color', '');
                            }
                        }
                    },
                    error: function() {
                        // Revert checkbox on error
                        this.checked = !this.checked;
                    }
                });
            });
        });
    </script>
</body>

</html>
