@extends('layouts.admin')

@section('title', 'Parking Installments')

@section('header', 'Parking Installment Management')

@section('content')
    <div class="max-w-6xl mx-auto">

        <!-- Add New Installment Form -->
        <div class="bg-white rounded-xl shadow-sm border border-gray-100 p-6 mb-8">
            <h3 class="text-lg font-bold text-gray-700 mb-4">Add New Installment</h3>
            <form action="{{ route('clients.parking.store') }}" method="POST">
                @csrf

                <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-3 gap-6">
                    <div>
                        <label class="block text-gray-700 text-sm font-bold mb-2">Project</label>
                        <div class="relative">
                            <select name="prj_id"
                                class="shadow appearance-none border rounded w-full py-2 px-3 text-gray-700 leading-tight focus:outline-none focus:shadow-outline focus:border-primary transition">
                                <option value="">Select Project...</option>
                                @foreach($projects as $project)
                                    <option value="{{ $project->prj_id }}">{{ $project->name }}</option>
                                @endforeach
                            </select>
                        </div>
                    </div>

                    <div>
                        <label class="block text-gray-700 text-sm font-bold mb-2">Building No.</label>
                        <input type="text" name="bldg_no"
                            class="shadow appearance-none border rounded w-full py-2 px-3 text-gray-700 leading-tight focus:outline-none focus:shadow-outline focus:border-primary transition">
                    </div>

                    <div>
                        <label class="block text-gray-700 text-sm font-bold mb-2">Parking No.</label>
                        <input type="text" name="park_no"
                            class="shadow appearance-none border rounded w-full py-2 px-3 text-gray-700 leading-tight focus:outline-none focus:shadow-outline focus:border-primary transition">
                    </div>

                    <div>
                        <label class="block text-gray-700 text-sm font-bold mb-2">Month</label>
                        <select name="mon"
                            class="shadow appearance-none border rounded w-full py-2 px-3 text-gray-700 leading-tight focus:outline-none focus:shadow-outline focus:border-primary transition">
                            @for($i = 1; $i <= 12; $i++)
                                <option value="{{ $i }}">{{ date('F', mktime(0, 0, 0, $i, 10)) }}</option>
                            @endfor
                        </select>
                    </div>

                    <div>
                        <label class="block text-gray-700 text-sm font-bold mb-2">Year</label>
                        <select name="yr"
                            class="shadow appearance-none border rounded w-full py-2 px-3 text-gray-700 leading-tight focus:outline-none focus:shadow-outline focus:border-primary transition">
                            @for($i = date('Y') - 2; $i <= date('Y') + 5; $i++)
                                <option value="{{ $i }}" @if($i == date('Y')) selected @endif>{{ $i }}</option>
                            @endfor
                        </select>
                    </div>

                    <div>
                        <label class="block text-gray-700 text-sm font-bold mb-2">Installment Amount</label>
                        <input type="number" step="0.01" name="park_inst"
                            class="shadow appearance-none border rounded w-full py-2 px-3 text-gray-700 leading-tight focus:outline-none focus:shadow-outline focus:border-primary transition">
                    </div>
                </div>

                <div class="mt-6 flex items-center justify-end">
                    <button
                        class="bg-primary hover:bg-emerald-600 text-white font-bold py-2 px-6 rounded-lg focus:outline-none focus:shadow-outline transition duration-200"
                        type="submit">
                        Save Installment
                    </button>
                </div>
            </form>
        </div>

        <!-- Data Table -->
        <div class="bg-white rounded-xl shadow-sm border border-gray-100 overflow-hidden">
            <h3 class="text-lg font-bold text-gray-700 p-6 border-b border-gray-100">Recent Installments</h3>

            <div class="overflow-x-auto">
                <table class="w-full text-left border-collapse">
                    <thead>
                        <tr
                            class="text-xs font-bold tracking-wider text-gray-500 uppercase bg-gray-50/50 border-b border-gray-100">
                            <th class="px-6 py-4">Date</th>
                            <th class="px-6 py-4">Project</th>
                            <th class="px-6 py-4">Unit</th>
                            <th class="px-6 py-4 text-right">Amount</th>
                            <th class="px-6 py-4 text-center">Actions</th>
                        </tr>
                    </thead>
                    <tbody class="divide-y divide-gray-100">
                        @forelse($installments as $inst)
                            <tr class="hover:bg-gray-50/50 transition duration-150">
                                <td class="px-6 py-3 text-sm text-gray-700 whitespace-nowrap">
                                    {{ $inst->mon }}/{{ $inst->yr }}
                                </td>
                                <td class="px-6 py-3 text-sm text-gray-700 whitespace-nowrap">
                                    {{ \App\Models\Project::find($inst->prj_id)->name ?? $inst->prj_id }}
                                </td>
                                <td class="px-6 py-3 text-sm text-gray-700 whitespace-nowrap">
                                    Bldg: {{ $inst->bldg_no }} - Parking: {{ $inst->park_no }}
                                </td>
                                <td class="px-6 py-3 text-sm text-right font-bold text-emerald-600 whitespace-nowrap">
                                    {{ number_format($inst->inst_amount, 2) }}
                                </td>
                                <td class="px-6 py-3 text-sm text-center">
                                    <button class="text-red-500 hover:text-red-700 transition">Delete</button>
                                </td>
                            </tr>
                        @empty
                            <tr>
                                <td colspan="5" class="px-6 py-8 text-center text-gray-500">No installments found.</td>
                            </tr>
                        @endforelse
                    </tbody>
                </table>
            </div>

            <div class="p-4 border-t border-gray-100">
                {{ $installments->links() }}
            </div>
        </div>
    </div>
@endsection