<!-- Transfer Request Modal -->
<div id="transferModal" class="fixed inset-0 bg-black bg-opacity-50 hidden z-50 overflow-y-auto modal-bg">
    <div class="flex items-center justify-center min-h-screen p-4">
        <div class="bg-white rounded-2xl shadow-2xl w-full max-w-lg overflow-hidden">
            <div
                class="bg-gradient-to-r from-indigo-600 to-blue-700 px-6 py-4 flex justify-between items-center text-white">
                <h3 class="text-xl font-bold">{{ __('Request Unit Transfer') }}</h3>
                <button onclick="closeModal('transferModal')" class="text-white hover:text-gray-200">
                    <i class="entypo-cancel text-2xl"></i>
                </button>
            </div>
            <form action="{{ route('clients.pending.process') }}" method="POST" class="p-6 space-y-4">
                @csrf
                <input type="hidden" name="prj_id" id="transfer_prj_id">
                <input type="hidden" name="type" value="MV">

                <div class="p-4 bg-indigo-50 rounded-xl border border-indigo-100">
                    <span
                        class="text-xs font-bold text-indigo-400 uppercase tracking-wider block mb-1">{{ __('Transferring Unit') }}</span>
                    <span id="transfer_flat_txt" class="text-lg font-black text-indigo-900 leading-tight"></span>
                </div>

                <div>
                    <label
                        class="block text-sm font-semibold text-gray-700 mb-1">{{ __('Transfer to (Member No)') }}</label>
                    <input type="text" name="cl_to"
                        class="w-full px-3 py-2 border border-gray-300 rounded-lg focus:ring-2 focus:ring-indigo-500"
                        required>
                </div>

                <div class="mt-4 flex justify-end gap-3">
                    <button type="button" onclick="closeModal('transferModal')"
                        class="px-4 py-2 bg-gray-500 text-white rounded-lg hover:bg-gray-600 transition">
                        {{ __('Close') }}
                    </button>
                    <button type="submit"
                        class="px-6 py-2 bg-indigo-600 text-white rounded-lg hover:bg-indigo-700 transition">
                        {{ __('Submit Request') }}
                    </button>
                </div>
            </form>
        </div>
    </div>
</div>

<!-- Refund Request Modal -->
<div id="refundModal" class="fixed inset-0 bg-black bg-opacity-50 hidden z-50 overflow-y-auto modal-bg">
    <div class="flex items-center justify-center min-h-screen p-4">
        <div class="bg-white rounded-2xl shadow-2xl w-full max-w-lg overflow-hidden">
            <div
                class="bg-gradient-to-r from-orange-600 to-red-700 px-6 py-4 flex justify-between items-center text-white">
                <h3 class="text-xl font-bold">{{ __('Request Unit Refund') }}</h3>
                <button onclick="closeModal('refundModal')" class="text-white hover:text-gray-200">
                    <i class="entypo-cancel text-2xl"></i>
                </button>
            </div>
            <form action="{{ route('clients.refund') }}" method="POST" class="p-6 space-y-4">
                @csrf
                <input type="hidden" name="prj_id" id="refund_prj_id">
                <input type="hidden" name="flt_id" id="refund_flt_id">
                <input type="hidden" name="cl_id" value="{{ $client->member_no }}">

                <div class="space-y-3">
                    <label
                        class="block text-sm font-semibold text-gray-700">{{ __('Select Receipts for Refund') }}</label>
                    <div id="receipts_list" class="space-y-2 max-h-60 overflow-y-auto">
                        <!-- Loaded via JS -->
                    </div>
                </div>

                <div class="mt-4 flex justify-end gap-3">
                    <button type="button" onclick="closeModal('refundModal')"
                        class="px-4 py-2 bg-gray-500 text-white rounded-lg hover:bg-gray-600 transition">
                        {{ __('Close') }}
                    </button>
                    <button type="submit"
                        class="px-6 py-2 bg-orange-600 text-white rounded-lg hover:bg-orange-700 transition">
                        {{ __('Submit Refund Request') }}
                    </button>
                </div>
            </form>
        </div>
    </div>
</div>

<!-- Edit Unit Modal -->
<div id="editUnitModal" class="fixed inset-0 bg-black bg-opacity-50 hidden z-50 overflow-y-auto modal-bg">
    <div class="flex items-center justify-center min-h-screen p-4">
        <div class="bg-white rounded-2xl shadow-2xl w-full max-w-lg overflow-hidden">
            <div
                class="bg-gradient-to-r from-sky-600 to-blue-700 px-6 py-4 flex justify-between items-center text-white">
                <h3 class="text-xl font-bold">{{ __('Edit Unit Details') }}</h3>
                <button onclick="closeModal('editUnitModal')" class="text-white hover:text-gray-200">
                    <i class="entypo-cancel text-2xl"></i>
                </button>
            </div>
            <form action="{{ route('clients.reservations.add', $client->cl_id) }}" method="POST" class="p-6 space-y-4">
                @csrf
                <input type="hidden" name="prj_id" id="edit_prj_id">
                <input type="hidden" name="old_bldg" id="edit_old_bldg">
                <input type="hidden" name="old_flat" id="edit_old_flat">

                <div class="grid grid-cols-2 gap-4">
                    <div>
                        <label class="block text-sm font-semibold text-gray-700 mb-1">{{ __('Building') }}</label>
                        <input type="text" name="bldg_id" id="edit_bldg_id"
                            class="w-full px-3 py-2 border border-gray-300 rounded-lg focus:ring-2 focus:ring-sky-500"
                            required>
                    </div>
                    <div>
                        <label class="block text-sm font-semibold text-gray-700 mb-1">{{ __('Unit No.') }}</label>
                        <input type="text" name="flat_num" id="edit_flat_num"
                            class="w-full px-3 py-2 border border-gray-300 rounded-lg focus:ring-2 focus:ring-sky-500"
                            required>
                    </div>
                    <div class="col-span-2">
                        <label class="block text-sm font-semibold text-gray-700 mb-1">{{ __('Floor') }}</label>
                        <input type="text" name="floor" id="edit_floor"
                            class="w-full px-3 py-2 border border-gray-300 rounded-lg focus:ring-2 focus:ring-sky-500"
                            required>
                    </div>
                </div>

                <div class="mt-4 flex justify-end gap-3">
                    <button type="button" onclick="closeModal('editUnitModal')"
                        class="px-4 py-2 bg-gray-500 text-white rounded-lg hover:bg-gray-600 transition">
                        {{ __('Close') }}
                    </button>
                    <button type="submit"
                        class="px-6 py-2 bg-sky-600 text-white rounded-lg hover:bg-sky-700 transition">
                        {{ __('Save Changes') }}
                    </button>
                </div>
            </form>
        </div>
    </div>
</div>

<!-- Savings Transfer Modal -->
<div id="transferSavingsModal" class="fixed inset-0 bg-black bg-opacity-50 hidden z-50 overflow-y-auto modal-bg">
    <div class="flex items-center justify-center min-h-screen p-4">
        <div class="bg-white rounded-2xl shadow-2xl w-full max-w-lg overflow-hidden">
            <div
                class="bg-gradient-to-r from-teal-600 to-emerald-700 px-6 py-4 flex justify-between items-center text-white">
                <h3 class="text-xl font-bold">{{ __('Transfer Savings') }}</h3>
                <button onclick="closeModal('transferSavingsModal')" class="text-white hover:text-gray-200">
                    <i class="entypo-cancel text-2xl"></i>
                </button>
            </div>
            <form action="{{ route('clients.transaction.save') }}" method="POST" class="p-6 space-y-4">
                @csrf
                <input type="hidden" name="from_id" value="{{ $client->cl_id }}">
                <input type="hidden" name="prj_id" id="savings_prj_id">
                <input type="hidden" name="type" value="to_cl">

                <div class="grid grid-cols-2 gap-4">
                    <div class="col-span-2">
                        <label
                            class="block text-sm font-semibold text-gray-700 mb-1">{{ __('Transfer to (Member No)') }}</label>
                        <input type="text" name="mem_no"
                            class="w-full px-3 py-2 border border-gray-300 rounded-lg focus:ring-2 focus:ring-emerald-500"
                            required>
                    </div>
                    <div>
                        <label class="block text-sm font-semibold text-gray-700 mb-1">{{ __('Amount') }}</label>
                        <input type="number" name="amount" id="savings_amount"
                            class="w-full px-3 py-2 border border-gray-300 rounded-lg focus:ring-2 focus:ring-emerald-500"
                            required>
                    </div>
                    <div>
                        <label class="block text-sm font-semibold text-gray-700 mb-1">{{ __('Base Amount') }}</label>
                        <input type="number" name="base_amount" id="savings_base_amount"
                            class="w-full px-3 py-2 border border-gray-300 rounded-lg bg-gray-50" readonly>
                    </div>
                </div>

                <div class="mt-4 flex justify-end gap-3">
                    <button type="button" onclick="closeModal('transferSavingsModal')"
                        class="px-4 py-2 bg-gray-500 text-white rounded-lg hover:bg-gray-600 transition">
                        {{ __('Close') }}
                    </button>
                    <button type="submit"
                        class="px-6 py-2 bg-emerald-600 text-white rounded-lg hover:bg-emerald-700 transition">
                        {{ __('Transfer') }}
                    </button>
                </div>
            </form>
        </div>
    </div>
</div>

<!-- Withdraw Savings Modal -->
<div id="withdrawSavingsModal" class="fixed inset-0 bg-black bg-opacity-50 hidden z-50 overflow-y-auto modal-bg">
    <div class="flex items-center justify-center min-h-screen p-4">
        <div class="bg-white rounded-2xl shadow-2xl w-full max-w-lg overflow-hidden">
            <div
                class="bg-gradient-to-r from-gray-600 to-gray-700 px-6 py-4 flex justify-between items-center text-white">
                <h3 class="text-xl font-bold">{{ __('Withdraw Savings') }}</h3>
                <button onclick="closeModal('withdrawSavingsModal')" class="text-white hover:text-gray-200">
                    <i class="entypo-cancel text-2xl"></i>
                </button>
            </div>
            <form action="{{ route('clients.transaction.save') }}" method="POST" class="p-6 space-y-4">
                @csrf
                <input type="hidden" name="from_id" value="{{ $client->cl_id }}">
                <input type="hidden" name="prj_id" id="withdraw_prj_id">
                <input type="hidden" name="type" value="chk">

                <div class="grid grid-cols-2 gap-4">
                    <div>
                        <label class="block text-sm font-semibold text-gray-700 mb-1">{{ __('Check No.') }}</label>
                        <input type="text" name="chk_num"
                            class="w-full px-3 py-2 border border-gray-300 rounded-lg focus:ring-2 focus:ring-gray-500"
                            required>
                    </div>
                    <div>
                        <label class="block text-sm font-semibold text-gray-700 mb-1">{{ __('Check Date') }}</label>
                        <input type="date" name="chk_date"
                            class="w-full px-3 py-2 border border-gray-300 rounded-lg focus:ring-2 focus:ring-gray-500"
                            required>
                    </div>
                    <div>
                        <label class="block text-sm font-semibold text-gray-700 mb-1">{{ __('Amount') }}</label>
                        <input type="number" name="amount" id="withdraw_amount"
                            class="w-full px-3 py-2 border border-gray-300 rounded-lg focus:ring-2 focus:ring-gray-500"
                            required>
                    </div>
                    <div class="col-span-2">
                        <label class="block text-sm font-semibold text-gray-700 mb-1">{{ __('Bank') }}</label>
                        <select name="chk_bnk"
                            class="w-full px-3 py-2 border border-gray-300 rounded-lg focus:ring-2 focus:ring-gray-500">
                            @foreach(\App\Models\Bank::all() as $bank)
                                <option value="{{ $bank->bank_id }}">{{ $bank->bank_name }}</option>
                            @endforeach
                        </select>
                    </div>
                </div>

                <div class="mt-4 flex justify-end gap-3">
                    <button type="button" onclick="closeModal('withdrawSavingsModal')"
                        class="px-4 py-2 bg-gray-500 text-white rounded-lg hover:bg-gray-600 transition">
                        {{ __('Close') }}
                    </button>
                    <button type="submit"
                        class="px-6 py-2 bg-gray-600 text-white rounded-lg hover:bg-gray-700 transition">
                        {{ __('Withdraw') }}
                    </button>
                </div>
            </form>
        </div>
    </div>
</div>

<!-- Add Parking Modal -->
<div id="addParkingModal" class="fixed inset-0 bg-black bg-opacity-50 hidden z-50 overflow-y-auto modal-bg">
    <div class="flex items-center justify-center min-h-screen p-4">
        <div class="bg-white rounded-2xl shadow-2xl w-full max-w-lg overflow-hidden">
            <div
                class="bg-gradient-to-r from-emerald-600 to-teal-700 px-6 py-4 flex justify-between items-center text-white">
                <h3 class="text-xl font-bold">{{ __('Add Parking Slot') }}</h3>
                <button onclick="closeModal('addParkingModal')" class="text-white hover:text-gray-200">
                    <i class="entypo-cancel text-2xl"></i>
                </button>
            </div>
            <form action="{{ route('clients.parking.store') }}" method="POST" class="p-6 space-y-4">
                @csrf
                <input type="hidden" name="cl_id" value="{{ $client->member_no }}">
                <input type="hidden" name="prj_id" id="park_prj_id">

                <div class="grid grid-cols-2 gap-4">
                    <div>
                        <label class="block text-sm font-semibold text-gray-700 mb-1">{{ __('Building') }}</label>
                        <input type="text" name="bldg"
                            class="w-full px-3 py-2 border border-gray-300 rounded-lg focus:ring-2 focus:ring-emerald-500"
                            required>
                    </div>
                    <div>
                        <label class="block text-sm font-semibold text-gray-700 mb-1">{{ __('Parking No.') }}</label>
                        <input type="text" name="park_no"
                            class="w-full px-3 py-2 border border-gray-300 rounded-lg focus:ring-2 focus:ring-emerald-500"
                            required>
                    </div>
                </div>

                <div class="mt-4 flex justify-end gap-3">
                    <button type="button" onclick="closeModal('addParkingModal')"
                        class="px-4 py-2 bg-gray-500 text-white rounded-lg hover:bg-gray-600 transition">
                        {{ __('Close') }}
                    </button>
                    <button type="submit"
                        class="px-6 py-2 bg-teal-600 text-white rounded-lg hover:bg-teal-700 transition">
                        {{ __('Add Parking') }}
                    </button>
                </div>
            </form>
        </div>
    </div>
</div>

<!-- Add Garden Modal -->
<div id="addGardenModal" class="fixed inset-0 bg-black bg-opacity-50 hidden z-50 overflow-y-auto modal-bg">
    <div class="flex items-center justify-center min-h-screen p-4">
        <div class="bg-white rounded-2xl shadow-2xl w-full max-w-lg overflow-hidden">
            <div
                class="bg-gradient-to-r from-blue-600 to-indigo-700 px-6 py-4 flex justify-between items-center text-white">
                <h3 class="text-xl font-bold">{{ __('Add Garden') }}</h3>
                <button onclick="closeModal('addGardenModal')" class="text-white hover:text-gray-200">
                    <i class="entypo-cancel text-2xl"></i>
                </button>
            </div>
            <form action="{{ route('clients.reservations.assign_garden') }}" method="POST" class="p-6 space-y-4">
                @csrf
                <input type="hidden" name="cl_id" value="{{ $client->member_no }}">
                <input type="hidden" name="prj_id" id="garden_prj_id">

                <div class="grid grid-cols-2 gap-4">
                    <div>
                        <label class="block text-sm font-semibold text-gray-700 mb-1">{{ __('Building') }}</label>
                        <input type="text" name="bldg"
                            class="w-full px-3 py-2 border border-gray-300 rounded-lg focus:ring-2 focus:ring-blue-500"
                            required>
                    </div>
                    <div>
                        <label class="block text-sm font-semibold text-gray-700 mb-1">{{ __('Unit No.') }}</label>
                        <input type="text" name="flat_num"
                            class="w-full px-3 py-2 border border-gray-300 rounded-lg focus:ring-2 focus:ring-blue-500"
                            required>
                    </div>
                    <div class="col-span-2">
                        <label class="block text-sm font-bold text-gray-700 mb-1">{{ __('Garden Area (m2)') }}</label>
                        <input type="number" step="0.01" name="garden_size"
                            class="w-full px-3 py-2 border-2 border-blue-200 rounded-lg focus:ring-2 focus:ring-blue-500 font-black text-blue-900"
                            placeholder="{{ __('Enter Garden Area...') }}" required>
                    </div>
                </div>

                <div class="mt-4 flex justify-end gap-3">
                    <button type="button" onclick="closeModal('addGardenModal')"
                        class="px-4 py-2 bg-gray-500 text-white rounded-lg hover:bg-gray-600 transition">
                        {{ __('Close') }}
                    </button>
                    <button type="submit"
                        class="px-6 py-2 bg-blue-600 text-white rounded-lg hover:bg-blue-700 transition">
                        {{ __('Confirm Assignment') }}
                    </button>
                </div>
            </form>
        </div>
    </div>
</div>

<!-- Add Roof Modal -->
<div id="addRoofModal" class="fixed inset-0 bg-black bg-opacity-50 hidden z-50 overflow-y-auto modal-bg">
    <div class="flex items-center justify-center min-h-screen p-4">
        <div class="bg-white rounded-2xl shadow-2xl w-full max-w-lg overflow-hidden">
            <div
                class="bg-gradient-to-r from-indigo-600 to-purple-700 px-6 py-4 flex justify-between items-center text-white">
                <h3 class="text-xl font-bold">{{ __('Add Roof') }}</h3>
                <button onclick="closeModal('addRoofModal')" class="text-white hover:text-gray-200">
                    <i class="entypo-cancel text-2xl"></i>
                </button>
            </div>
            <form action="{{ route('clients.parking.store') }}" method="POST" class="p-6 space-y-4">
                @csrf
                <input type="hidden" name="cl_id" value="{{ $client->member_no }}">
                <input type="hidden" name="prj_id" id="roof_prj_id">
                <input type="hidden" name="type" value="roof">

                <div class="grid grid-cols-2 gap-4">
                    <div>
                        <label class="block text-sm font-semibold text-gray-700 mb-1">{{ __('Building') }}</label>
                        <input type="text" name="bldg"
                            class="w-full px-3 py-2 border border-gray-300 rounded-lg focus:ring-2 focus:ring-indigo-500"
                            required>
                    </div>
                    <div>
                        <label class="block text-sm font-semibold text-gray-700 mb-1">{{ __('Unit No.') }}</label>
                        <input type="text" name="park_no"
                            class="w-full px-3 py-2 border border-gray-300 rounded-lg focus:ring-2 focus:ring-indigo-500"
                            required>
                    </div>
                </div>

                <div class="mt-4 flex justify-end gap-3">
                    <button type="button" onclick="closeModal('addRoofModal')"
                        class="px-4 py-2 bg-gray-500 text-white rounded-lg hover:bg-gray-600 transition">
                        {{ __('Close') }}
                    </button>
                    <button type="submit"
                        class="px-6 py-2 bg-indigo-600 text-white rounded-lg hover:bg-indigo-700 transition">
                        {{ __('Add Roof') }}
                    </button>
                </div>
            </form>
        </div>
    </div>
</div>

<!-- Edit Parking Modal -->
<div id="editParkingModal" class="fixed inset-0 bg-black bg-opacity-50 hidden z-50 overflow-y-auto modal-bg">
    <div class="flex items-center justify-center min-h-screen p-4">
        <div class="bg-white rounded-2xl shadow-2xl w-full max-w-lg overflow-hidden">
            <div
                class="bg-gradient-to-r from-amber-600 to-orange-700 px-6 py-4 flex justify-between items-center text-white">
                <h3 class="text-xl font-bold">{{ __('Edit Parking Slot') }}</h3>
                <button onclick="closeModal('editParkingModal')" class="text-white hover:text-gray-200">
                    <i class="entypo-cancel text-2xl"></i>
                </button>
            </div>
            <form action="{{ route('clients.parking.update') }}" method="POST" class="p-6 space-y-4">
                @csrf
                <input type="hidden" name="id" id="edit_park_id">

                <div class="grid grid-cols-2 gap-4">
                    <div>
                        <label class="block text-sm font-semibold text-gray-700 mb-1">{{ __('Building') }}</label>
                        <input type="text" name="bldg" id="edit_park_bldg"
                            class="w-full px-3 py-2 border border-gray-300 rounded-lg focus:ring-2 focus:ring-amber-500"
                            required>
                    </div>
                    <div>
                        <label class="block text-sm font-semibold text-gray-700 mb-1">{{ __('Parking No.') }}</label>
                        <input type="text" name="park_no" id="edit_park_no"
                            class="w-full px-3 py-2 border border-gray-300 rounded-lg focus:ring-2 focus:ring-amber-500"
                            required>
                    </div>
                </div>

                <div class="mt-4 flex justify-end gap-3">
                    <button type="button" onclick="closeModal('editParkingModal')"
                        class="px-4 py-2 bg-gray-500 text-white rounded-lg hover:bg-gray-600 transition">
                        {{ __('Close') }}
                    </button>
                    <button type="submit"
                        class="px-6 py-2 bg-amber-600 text-white rounded-lg hover:bg-amber-700 transition">
                        {{ __('Save Changes') }}
                    </button>
                </div>
            </form>
        </div>
    </div>
</div>

<!-- Edit Garden Modal -->
<div id="editGardenModal" class="fixed inset-0 bg-black bg-opacity-50 hidden z-50 overflow-y-auto modal-bg">
    <div class="flex items-center justify-center min-h-screen p-4">
        <div class="bg-white rounded-2xl shadow-2xl w-full max-w-lg overflow-hidden">
            <div
                class="bg-gradient-to-r from-emerald-600 to-teal-700 px-6 py-4 flex justify-between items-center text-white">
                <h3 class="text-xl font-bold">{{ __('Edit Garden Assignment') }}</h3>
                <button onclick="closeModal('editGardenModal')" class="text-white hover:text-gray-200">
                    <i class="entypo-cancel text-2xl"></i>
                </button>
            </div>
            <form action="{{ route('clients.reservations.assign_garden') }}" method="POST" class="p-6 space-y-4">
                @csrf
                <input type="hidden" name="resv_id" id="edit_garden_resv_id">

                <div class="p-4 bg-emerald-50 rounded-xl border border-emerald-100 flex justify-between items-center">
                    <div>
                        <span
                            class="text-xs font-bold text-emerald-400 uppercase tracking-wider block mb-1">{{ __('Unit Details') }}</span>
                        <span class="text-lg font-black text-emerald-900 leading-tight">
                            {{ __('Building') }}: <span id="edit_garden_bldg"></span> •
                            {{ __('Unit') }}: <span id="edit_garden_flat"></span>
                        </span>
                    </div>
                    <i class="entypo-leaf text-3xl text-emerald-200"></i>
                </div>

                <div>
                    <label class="block text-sm font-bold text-gray-700 mb-1">{{ __('Garden Area (m2)') }}</label>
                    <input type="number" step="0.01" name="garden_size" id="edit_garden_size"
                        class="w-full px-3 py-2 border-2 border-emerald-200 rounded-lg focus:ring-2 focus:ring-emerald-500 font-black text-emerald-900"
                        placeholder="{{ __('Enter Garden Area...') }}" required>
                </div>

                <div class="mt-4 flex justify-end gap-3">
                    <button type="button" onclick="closeModal('editGardenModal')"
                        class="px-4 py-2 bg-gray-500 text-white rounded-lg hover:bg-gray-600 transition">
                        {{ __('Close') }}
                    </button>
                    <button type="submit"
                        class="px-6 py-2 bg-emerald-600 text-white rounded-lg hover:bg-emerald-700 transition">
                        {{ __('Update Assignment') }}
                    </button>
                </div>
            </form>
        </div>
    </div>
</div>

<!-- Delete Confirmation Modal -->
<div id="deleteConfirmModal" class="fixed inset-0 bg-black bg-opacity-50 hidden z-50 overflow-y-auto modal-bg">
    <div class="flex items-center justify-center min-h-screen p-4">
        <div class="bg-white rounded-2xl shadow-2xl w-full max-w-sm overflow-hidden transform transition-all">
            <div class="p-6 text-center">
                <div class="mx-auto flex items-center justify-center h-12 w-12 rounded-full bg-red-100 mb-4">
                    <i class="entypo-trash text-2xl text-red-600"></i>
                </div>
                <h3 class="text-lg leading-6 font-bold text-gray-900" id="deleteConfirmTitle">{{ __('Delete Item') }}
                </h3>
                <div class="mt-2">
                    <p class="text-sm text-gray-500" id="deleteConfirmMessage">
                        {{ __('Are you sure you want to delete this item? This action cannot be undone.') }}
                    </p>
                </div>
            </div>
            <div class="bg-gray-50 px-4 py-3 sm:px-6 sm:flex sm:flex-row-reverse gap-2">
                <button type="button" id="confirmDeleteBtn"
                    class="w-full inline-flex justify-center rounded-md border border-transparent shadow-sm px-4 py-2 bg-red-600 text-base font-medium text-white hover:bg-red-700 focus:outline-none focus:ring-2 focus:ring-offset-2 focus:ring-red-500 sm:ml-3 sm:w-auto sm:text-sm">
                    {{ __('Yes, Delete') }}
                </button>
                <button type="button" onclick="closeModal('deleteConfirmModal')"
                    class="mt-3 w-full inline-flex justify-center rounded-md border border-gray-300 shadow-sm px-4 py-2 bg-white text-base font-medium text-gray-700 hover:bg-gray-50 focus:outline-none focus:ring-2 focus:ring-offset-2 focus:ring-indigo-500 sm:mt-0 sm:ml-3 sm:w-auto sm:text-sm">
                    {{ __('Cancel') }}
                </button>
            </div>
        </div>
    </div>
</div>