<!-- Add Client Modal -->
<div id="addClientModal" class="fixed inset-0 z-50 hidden overflow-y-auto">
    <div class="flex items-center justify-center min-h-screen p-4 text-center sm:block sm:p-0">
        <div class="fixed inset-0 transition-opacity bg-gray-500 bg-opacity-75" onclick="closeAddClientModal()"></div>

        <div
            class="inline-block w-full max-w-4xl my-8 overflow-hidden text-start align-middle transition-all transform bg-white shadow-2xl rounded-2xl">
            <!-- Modal Header -->
            <div class="px-8 py-5 border-b border-gray-100 flex justify-between items-center bg-emerald-50/50">
                <h3 class="text-xl font-bold text-emerald-800">{{ __('Add New Client') }}</h3>
                <button onclick="closeAddClientModal()"
                    class="text-emerald-400 hover:text-emerald-600 transition-colors">
                    <svg class="w-6 h-6" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M6 18L18 6M6 6l12 12">
                        </path>
                    </svg>
                </button>
            </div>

            <!-- Modal Content -->
            <form id="addClientForm" method="POST" action="{{ route('clients.store') }}" class="px-8 py-8">
                @csrf
                <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-3 gap-6">

                    <!-- Section 1: Membership Info -->
                    <div class="col-span-full border-b border-gray-100 pb-2 mb-2">
                        <span class="text-emerald-600 font-bold flex items-center gap-2">
                            <i class="entypo-vcard"></i> {{ __('Membership Information') }}
                        </span>
                    </div>

                    <div>
                        <label class="block text-sm font-semibold text-gray-700 mb-1">{{ __('Member Number') }} <span
                                class="text-red-500">*</span></label>
                        <input type="text" name="old_member_no" value="{{ $next_old_member_no }}"
                            class="w-full px-4 py-2 border border-blue-200 rounded-lg focus:ring-2 focus:ring-blue-100 focus:border-blue-400 transition-all font-bold">
                    </div>

                    <div>
                        <label class="block text-sm font-semibold text-gray-700 mb-1">{{ __('Computer Code') }}</label>
                        <input type="text" name="member_no" value="{{ $next_member_no }}" readonly
                            class="w-full px-4 py-2 bg-gray-50 border border-gray-200 rounded-lg text-gray-500 font-medium cursor-not-allowed">
                    </div>

                    <div>
                        <label
                            class="block text-sm font-semibold text-gray-700 mb-1">{{ __('Membership Date') }}</label>
                        <input type="date" name="member_start_date" value="{{ date('Y-m-d') }}"
                            class="w-full px-4 py-2 border border-gray-200 rounded-lg focus:ring-2 focus:ring-emerald-100 focus:border-emerald-400">
                    </div>

                    <div>
                        <label class="block text-sm font-semibold text-gray-700 mb-1">{{ __('File Number') }}</label>
                        <input type="text" name="file_no" value="{{ $next_file_no }}"
                            class="w-full px-4 py-2 border border-gray-200 rounded-lg focus:ring-2 focus:ring-emerald-100 focus:border-emerald-400">
                    </div>

                    <!-- Section 2: Personal Info -->
                    <div class="col-span-full border-b border-gray-100 pb-2 mb-2 mt-4">
                        <span class="text-emerald-600 font-bold flex items-center gap-2">
                            <i class="entypo-user"></i> {{ __('Personal Information') }}
                        </span>
                    </div>

                    <div class="lg:col-span-2">
                        <label class="block text-sm font-semibold text-gray-700 mb-1">{{ __('Arabic Name') }} <span
                                class="text-red-500">*</span></label>
                        <input type="text" name="arabic_name" id="ar_name_input" required
                            class="w-full px-4 py-2 border border-emerald-200 rounded-lg focus:ring-2 focus:ring-emerald-100 focus:border-emerald-400 transition-all text-lg font-bold">
                        <div id="nameExistsAlert" class="mt-1 text-xs text-red-500 font-bold hidden">
                            {{ __('This name already exists!') }}
                        </div>
                    </div>

                    <div>
                        <label class="block text-sm font-semibold text-gray-700 mb-1">{{ __('English Name') }} <span
                                class="text-red-500">*</span></label>
                        <input type="text" name="english_name" required
                            class="w-full px-4 py-2 border border-gray-200 rounded-lg focus:ring-2 focus:ring-emerald-100 focus:border-emerald-400">
                    </div>

                    <div>
                        <label class="block text-sm font-semibold text-gray-700 mb-1">{{ __('National ID') }} <span
                                class="text-red-500">*</span></label>
                        <input type="text" name="nat_id" maxlength="14" required
                            class="w-full px-4 py-2 border border-gray-200 rounded-lg focus:ring-2 focus:ring-emerald-100 focus:border-emerald-400">
                    </div>

                    <div>
                        <label
                            class="block text-sm font-semibold text-gray-700 mb-1">{{ __('Military Card ID') }}</label>
                        <input type="text" name="milit_card_id"
                            class="w-full px-4 py-2 border border-gray-200 rounded-lg focus:ring-2 focus:ring-emerald-100 focus:border-emerald-400">
                    </div>

                    <div>
                        <label class="block text-sm font-semibold text-gray-700 mb-1">{{ __('Nationality') }}</label>
                        <input type="text" name="nationality" value="مصرى"
                            class="w-full px-4 py-2 border border-gray-200 rounded-lg focus:ring-2 focus:ring-emerald-100 focus:border-emerald-400">
                    </div>

                    <div>
                        <label class="block text-sm font-semibold text-gray-700 mb-1">{{ __('Gender') }}</label>
                        <select name="gender"
                            class="w-full px-4 py-2 border border-gray-200 rounded-lg focus:ring-2 focus:ring-emerald-100 focus:border-emerald-400">
                            <option value="ذكـر">{{ __('Male') }}</option>
                            <option value="انثى">{{ __('Female') }}</option>
                        </select>
                    </div>

                    <!-- Section 3: Contact & Financial -->
                    <div class="col-span-full border-b border-gray-100 pb-2 mb-2 mt-4">
                        <span class="text-emerald-600 font-bold flex items-center gap-2">
                            <i class="entypo-phone"></i> {{ __('Contact & Financial') }}
                        </span>
                    </div>

                    <div>
                        <label class="block text-sm font-semibold text-gray-700 mb-1">{{ __('Mobile') }} <span
                                class="text-red-500">*</span></label>
                        <input type="text" name="mobile" maxlength="11" required
                            class="w-full px-4 py-2 border border-emerald-200 rounded-lg focus:ring-2 focus:ring-emerald-100 focus:border-emerald-400 transition-all font-bold">
                    </div>

                    <div>
                        <label class="block text-sm font-semibold text-gray-700 mb-1">{{ __('Email') }}</label>
                        <input type="email" name="per_email"
                            class="w-full px-4 py-2 border border-gray-200 rounded-lg focus:ring-2 focus:ring-emerald-100 focus:border-emerald-400">
                    </div>

                    <div>
                        <label class="block text-sm font-semibold text-gray-700 mb-1">{{ __('State/City') }}</label>
                        <select name="city"
                            class="w-full px-4 py-2 border border-gray-200 rounded-lg focus:ring-2 focus:ring-emerald-100 focus:border-emerald-400">
                            @foreach($states as $state)
                                <option value="{{ $state->id }}" @selected($state->name == 'القاهرة')>{{ $state->name }}
                                </option>
                            @endforeach
                        </select>
                    </div>

                    <div>
                        <label class="block text-sm font-semibold text-gray-700 mb-1">{{ __('Area') }}</label>
                        <input type="text" name="state"
                            class="w-full px-4 py-2 border border-gray-200 rounded-lg focus:ring-2 focus:ring-emerald-100 focus:border-emerald-400">
                    </div>

                    <div class="lg:col-span-2">
                        <label class="block text-sm font-semibold text-gray-700 mb-1">{{ __('Address') }}</label>
                        <input type="text" name="address"
                            class="w-full px-4 py-2 border border-gray-200 rounded-lg focus:ring-2 focus:ring-emerald-100 focus:border-emerald-400">
                    </div>

                    <div>
                        <label class="block text-sm font-semibold text-gray-700 mb-1">{{ __('Bank Name') }}</label>
                        <input type="text" name="bank_name"
                            class="w-full px-4 py-2 border border-gray-200 rounded-lg focus:ring-2 focus:ring-emerald-100 focus:border-emerald-400">
                    </div>

                    <div>
                        <label class="block text-sm font-semibold text-gray-700 mb-1">{{ __('Account Number') }}</label>
                        <input type="text" name="account_no"
                            class="w-full px-4 py-2 border border-gray-200 rounded-lg focus:ring-2 focus:ring-emerald-100 focus:border-emerald-400">
                    </div>

                    <!-- Section 4: Membership Type -->
                    <div class="col-span-full border-b border-gray-100 pb-2 mb-2 mt-4">
                        <span class="text-emerald-600 font-bold flex items-center gap-2">
                            <i class="entypo-list"></i> {{ __('Membership Details') }}
                        </span>
                    </div>

                    <div>
                        <label
                            class="block text-sm font-semibold text-gray-700 mb-1">{{ __('Membership Type') }}</label>
                        <select name="member_type"
                            class="w-full px-4 py-2 border border-gray-200 rounded-lg focus:ring-2 focus:ring-emerald-100 focus:border-emerald-400">
                            <option value="لا يوجد">{{ __('None') }}</option>
                            <option value="ضابط دفاع جوى">{{ __('Air Defense Officer') }}</option>
                            <option value="ضابط قوات مسلحه">{{ __('Armed Forces Officer') }}</option>
                            <option value="عضو دار الدفاع">{{ __('Defense House Member') }}</option>
                            <option value="منتفع">{{ __('Beneficiary') }}</option>
                            <option value="أقارب حتى الدرجه 3">{{ __('Relatives up to 3rd degree') }}</option>
                        </select>
                    </div>

                    <div class="lg:col-span-2">
                        <label class="block text-sm font-semibold text-gray-700 mb-1">{{ __('Comment') }}</label>
                        <input type="text" name="comment"
                            class="w-full px-4 py-2 border border-gray-200 rounded-lg focus:ring-2 focus:ring-emerald-100 focus:border-emerald-400">
                    </div>

                </div>

                <!-- Modal Footer -->
                <div class="mt-10 pt-6 border-t border-gray-100 flex justify-end gap-4">
                    <button type="button" onclick="closeAddClientModal()"
                        class="px-6 py-2 text-gray-600 hover:text-gray-800 font-medium transition-colors">
                        {{ __('Cancel') }}
                    </button>
                    <button type="submit" id="saveClientBtn"
                        class="px-10 py-2 bg-emerald-600 text-white rounded-xl font-bold hover:bg-emerald-700 shadow-lg shadow-emerald-100 transition-all flex items-center gap-2">
                        <i class="entypo-check"></i> {{ __('Save Client') }}
                    </button>
                </div>
            </form>
        </div>
    </div>
</div>

@push('scripts')
    <script>
        function openAddClientModal() {
            document.getElementById('addClientModal').classList.remove('hidden');
        }

        function closeAddClientModal() {
            document.getElementById('addClientModal').classList.add('hidden');
        }

        // Check for existing name
        document.getElementById('ar_name_input').addEventListener('blur', function () {
            const name = this.value;
            if (!name) return;

            fetch('{{ route("clients.check_existence") }}', {
                method: 'POST',
                headers: {
                    'Content-Type': 'application/json',
                    'X-CSRF-TOKEN': '{{ csrf_token() }}'
                },
                body: JSON.stringify({ name: name })
            })
                .then(r => r.json())
                .then(data => {
                    const alert = document.getElementById('nameExistsAlert');
                    if (data.exists) {
                        alert.classList.remove('hidden');
                        this.classList.add('border-red-500');
                    } else {
                        alert.classList.add('hidden');
                        this.classList.remove('border-red-500');
                    }
                });
        });

        // Form Submission
        document.getElementById('addClientForm').addEventListener('submit', function (e) {
            e.preventDefault();

            const btn = document.getElementById('saveClientBtn');
            const originalText = btn.innerHTML;
            btn.innerHTML = '<i class="entypo-cw spin"></i> {{ __('Saving...') }}';
            btn.disabled = true;

            const formData = new FormData(this);
            const data = Object.fromEntries(formData.entries());

            fetch(this.action, {
                method: 'POST',
                headers: {
                    'Content-Type': 'application/json',
                    'X-CSRF-TOKEN': '{{ csrf_token() }}'
                },
                body: JSON.stringify(data)
            })
                .then(r => r.json())
                .then(data => {
                    if (data.success) {
                        alert(data.message);
                        window.location.reload();
                    } else {
                        alert('Error: ' + data.message);
                        btn.innerHTML = originalText;
                        btn.disabled = false;
                    }
                })
                .catch(error => {
                    console.error('Error:', error);
                    alert('Failed to save client. Please check validation and try again.');
                    btn.innerHTML = originalText;
                    btn.disabled = false;
                });
        });
    </script>
    <style>
        @keyframes spin {
            from {
                transform: rotate(0deg);
            }

            to {
                transform: rotate(360deg);
            }
        }

        .spin {
            animation: spin 2s linear infinite;
            display: inline-block;
        }
    </style>
@endpush