@extends('layouts.admin')

@section('content')
    <div class="bg-white rounded-xl shadow-lg p-6">
        <div class="flex flex-col md:flex-row justify-between items-center mb-8 gap-4 border-b border-gray-100 pb-6">
            <h2 class="text-2xl font-bold bg-gradient-to-r from-emerald-600 to-teal-600 bg-clip-text text-transparent">
                {{ __('Clients Management') }}
            </h2>
            
            <div class="flex flex-wrap gap-3 items-center">
                <form action="{{ route('clients.index') }}" method="GET" class="flex gap-2">
                    <select name="prj" class="rounded-lg border-gray-300 text-sm focus:ring-emerald-500 focus:border-emerald-500 pr-10">
                        <option value="0">{{ __('All Projects') }}</option>
                        @foreach($projects as $project)
                            <option value="{{ $project->prj_id }}" {{ request('prj') == $project->prj_id ? 'selected' : '' }}>
                                {{ $project->name }}
                            </option>
                        @endforeach
                        <option value="9999" {{ request('prj') == '9999' ? 'selected' : '' }}>{{ __('Full Search') }}</option>
                    </select>

                    <div class="relative group">
                        <input type="text" id="searchInput" name="search" value="{{ request('search') }}" 
                               autocomplete="off"
                               class="rounded-lg border-gray-300 text-sm ps-10 pe-4 focus:ring-emerald-500 focus:border-emerald-500 w-64 transition-all duration-300 focus:w-80" 
                               placeholder="{{ __('Search by name, ID, or file...') }}">
                        <div class="absolute inset-y-0 start-0 ps-3 flex items-center pointer-events-none">
                            <i class="entypo-search text-gray-400"></i>
                        </div>
                        <!-- Dropdown Menu -->
                        <div id="searchDropdown" class="absolute z-50 w-full mt-1 bg-white rounded-lg shadow-xl border border-gray-100 hidden max-h-60 overflow-y-auto">
                            <!-- Results will be injected here -->
                        </div>
                    </div>

                    <button type="submit" class="bg-emerald-600 text-white px-4 py-2 rounded-lg hover:bg-emerald-700 transition duration-150 shadow-md">
                        {{ __('Search') }}
                    </button>
                    @if(request()->has('search') || request()->has('prj'))
                        <a href="{{ route('clients.index') }}" class="text-gray-500 hover:text-gray-700 flex items-center px-2">
                            <i class="entypo-cancel"></i>
                        </a>
                    @endif
                </form>

                <button onclick="openAddClientModal()" class="bg-white border border-emerald-600 text-emerald-600 px-4 py-2 rounded-lg hover:bg-emerald-50 transition duration-150 font-semibold shadow-sm">
                    <i class="entypo-plus mx-1"></i> {{ __('Add Client') }}
                </button>
            </div>
        </div>

        <div class="overflow-x-auto rounded-xl border border-gray-100">
            <table class="min-w-full divide-y divide-gray-200">
                <thead class="bg-gray-50/50">
                    <tr class="text-xs font-bold text-gray-600 uppercase tracking-widest text-center">
                        <th class="px-3 py-4 border-e border-gray-200">{{ __('File No') }}</th>
                        <th class="px-3 py-4 border-e border-gray-200">{{ __('Memb. No') }}</th>
                        <th class="px-6 py-4 border-e border-gray-200 text-start">{{ __('Client Name') }}</th>
                        <th class="px-3 py-4 border-e border-gray-200">{{ __('Mobile') }}</th>
                        <th class="px-3 py-4 border-e border-gray-200">{{ __('Project') }}</th>
                        <th class="px-3 py-4 border-e border-gray-200">{{ __('Phase') }}</th>
                        <th class="px-3 py-4 border-e border-gray-200">{{ __('Area') }}</th>
                        <th class="px-3 py-4 border-e border-gray-200">{{ __('Building') }}</th>
                        <th class="px-3 py-4 border-e border-gray-200">{{ __('Unit') }}</th>
                        <th class="px-3 py-4">{{ __('Actions') }}</th>
                    </tr>
                </thead>
                <tbody class="bg-white divide-y divide-gray-100">
                    @forelse($clients as $client)
                        @php
                            $rowStyle = "";
                            if ($client->action == 'on') $rowStyle = "bg-red-50"; // Closed
                            // Add logic for deceased if needed from client data
                        @endphp
                        <tr class="hover:bg-emerald-50/30 transition-colors {{ $rowStyle }}">
                            <td class="px-3 py-2 text-center text-sm font-medium text-gray-500 border-e border-gray-50">
                                {{ $client->file_no }}
                            </td>
                            <td class="px-3 py-2 text-center text-sm font-semibold text-emerald-700 border-e border-gray-50">
                                {{ $client->old_member_no }}
                            </td>
                            <td class="px-6 py-2 text-start text-sm font-bold text-gray-900 border-e border-gray-50">
                                <div class="flex flex-col">
                                    <span>{{ $client->arabic_name }}</span>
                                    @if($client->action == 'on')
                                        <span class="text-[10px] text-red-500 font-normal">({{ __('Closed') }})</span>
                                    @endif
                                </div>
                            </td>
                            <td class="px-3 py-2 text-center text-sm text-gray-600 border-r border-gray-50">
                                {{ $client->mobile }}
                            </td>
                            <td class="px-3 py-2 text-center text-xs text-gray-700 border-r border-gray-50 max-w-[120px] truncate">
                                {{ $client->project_name ?? '-' }}
                            </td>
                            <td class="px-3 py-2 text-center text-xs text-gray-600 border-r border-gray-50 whitespace-nowrap">
                                @if($client->sess == '1')
                                    @if($client->subsess == '1')
                                        <span class="px-2 py-0.5 bg-blue-50 text-blue-700 rounded-full border border-blue-100">{{ __('Phase 1 Rem.') }}</span>
                                    @else
                                        <span class="px-2 py-0.5 bg-emerald-50 text-emerald-700 rounded-full border border-emerald-100">{{ __('Phase 1') }}</span>
                                    @endif
                                @elseif($client->sess == '2')
                                    <span class="px-2 py-0.5 bg-purple-50 text-purple-700 rounded-full border border-purple-100">{{ __('Phase 2') }}</span>
                                @elseif($client->sess == '3')
                                    <span class="px-2 py-0.5 bg-orange-50 text-orange-700 rounded-full border border-orange-100">{{ __('Phase 3') }}</span>
                                @elseif($client->sess == '111')
                                    <span class="px-2 py-0.5 bg-sky-50 text-sky-700 rounded-full border border-sky-100">{{ __('Marine') }}</span>
                                @else
                                    <span class="px-2 py-0.5 bg-gray-50 text-gray-600 rounded-full border border-gray-100">{{ $client->sess }}</span>
                                @endif
                            </td>
                            <td class="px-3 py-2 text-center text-sm text-gray-600 border-r border-gray-50">
                                {{ $client->sales_area ?? '-' }}
                            </td>
                            <td class="px-3 py-2 text-center text-sm font-medium text-gray-900 border-r border-gray-50">
                                {{ $client->bldg_id ?? '-' }}
                            </td>
                            <td class="px-3 py-2 text-center text-sm font-bold text-emerald-600 border-e border-gray-50">
                                {{ $client->flat_num ?? '-' }} <span class="text-xs text-gray-400 font-normal">({{ $client->flat_txt ?? '-' }})</span>
                            </td>
                            <td class="px-2 py-3 text-center">
                                <div class="flex flex-wrap gap-1.5 justify-center max-w-[600px] mx-auto">
                                    <!-- Row 1: Main Financial Actions -->
                                    <a href="{{ route('clients.reservations', $client->cl_id) }}" 
                                       class="inline-flex items-center gap-1 px-2 py-1 bg-purple-500 text-white rounded text-xs font-medium hover:bg-purple-600 transition-all shadow-sm hover:shadow-md whitespace-nowrap">
                                        <i class="entypo-home"></i>
                                        <span>{{ __('Units') }}</span>
                                    </a>
                                    <a href="{{ route('clients.account_statement', $client->cl_id) }}" 
                                       class="inline-flex items-center gap-1 px-2 py-1 bg-emerald-500 text-white rounded text-xs font-medium hover:bg-emerald-600 transition-all shadow-sm hover:shadow-md whitespace-nowrap">
                                        <i class="entypo-chart-bar"></i>
                                        <span>{{ __('Account') }}</span>
                                    </a>
                                    <a href="{{ route('clients.checks', $client->cl_id) }}" 
                                       class="inline-flex items-center gap-1 px-2 py-1 bg-orange-500 text-white rounded text-xs font-medium hover:bg-orange-600 transition-all shadow-sm hover:shadow-md whitespace-nowrap">
                                        <i class="entypo-clipboard"></i>
                                        <span>{{ __('Checks') }}</span>
                                    </a>
                                    <a href="{{ route('clients.payments', $client->cl_id) }}" 
                                       onclick="window.open(this.href, 'PaymentStatement', 'width=850,height=900,scrollbars=yes,resizable=yes'); return false;"
                                       class="inline-flex items-center gap-1 px-2 py-1 bg-blue-500 text-white rounded text-xs font-medium hover:bg-blue-600 transition-all shadow-sm hover:shadow-md whitespace-nowrap">
                                        <i class="entypo-doc-text"></i>
                                        <span>{{ __('Statement') }}</span>
                                    </a>
                                    <a href="{{ route('clients.documents', $client->cl_id) }}" 
                                       class="inline-flex items-center gap-1 px-2 py-1 bg-rose-500 text-white rounded text-xs font-medium hover:bg-rose-600 transition-all shadow-sm hover:shadow-md whitespace-nowrap">
                                        <i class="entypo-attach"></i>
                                        <span>{{ __('Files') }}</span>
                                    </a>
                                    
                                    <!-- Row 2: Management Actions -->
                                    <a href="{{ route('clients.comments', $client->old_member_no) }}" 
                                       class="inline-flex items-center gap-1 px-2 py-1 bg-indigo-500 text-white rounded text-xs font-medium hover:bg-indigo-600 transition-all shadow-sm hover:shadow-md whitespace-nowrap">
                                        <i class="entypo-comment"></i>
                                        <span>{{ __('Notes') }}</span>
                                    </a>
                                    <a href="#" 
                                       onclick="openPrintOrderModal('{{ $client->cl_id }}', '{{ $client->arabic_name }}'); return false;"
                                       class="inline-flex items-center gap-1 px-2 py-1 bg-emerald-600 text-white rounded text-xs font-medium hover:bg-emerald-700 transition-all shadow-sm hover:shadow-md whitespace-nowrap">
                                        <i class="entypo-print"></i>
                                        <span>{{ __('Print Order') }}</span>
                                    </a>
                                    <a href="{{ route('clients.show', $client->cl_id) }}" 
                                       class="inline-flex items-center gap-1 px-2 py-1 bg-gray-600 text-white rounded text-xs font-medium hover:bg-gray-700 transition-all shadow-sm hover:shadow-md whitespace-nowrap">
                                        <i class="entypo-eye"></i>
                                        <span>{{ __('View') }}</span>
                                    </a>
                                    <a href="{{ route('clients.edit', $client->cl_id) }}" 
                                       class="inline-flex items-center gap-1 px-2 py-1 bg-amber-500 text-white rounded text-xs font-medium hover:bg-amber-600 transition-all shadow-sm hover:shadow-md whitespace-nowrap">
                                        <i class="entypo-pencil"></i>
                                        <span>{{ __('Edit') }}</span>
                                    </a>
                                    <form action="{{ route('clients.delete', $client->cl_id) }}" method="POST" class="inline-block" onsubmit="return confirm('{{ __('Are you sure you want to delete this client?') }}')">
                                        @csrf
                                        @method('DELETE')
                                        <button type="submit" 
                                                class="inline-flex items-center gap-1 px-2 py-1 bg-red-500 text-white rounded text-xs font-medium hover:bg-red-600 transition-all shadow-sm hover:shadow-md whitespace-nowrap">
                                            <i class="entypo-trash"></i>
                                            <span>{{ __('Delete') }}</span>
                                        </button>
                                    </form>
                                </div>
                            </td>
                        </tr>
                    @empty
                        <tr>
                            <td colspan="10" class="px-6 py-10 text-center text-gray-500 italic">
                                {{ __('No clients found matching your criteria.') }}
                            </td>
                        </tr>
                    @endforelse
                </tbody>
            </table>
        </div>

        <div class="mt-8">
            {{ $clients->appends(request()->input())->links() }}
        </div>
    </div>

    @include('admin.clients.modals.print_payment_order')
    @include('admin.clients.modals.add_client')
@endsection

@push('scripts')
<script>
    document.addEventListener('DOMContentLoaded', function() {
        const searchInput = document.getElementById('searchInput');
        const searchDropdown = document.getElementById('searchDropdown');
        let searchTimeout;

        searchInput.addEventListener('input', function() {
            clearTimeout(searchTimeout);
            const query = this.value.trim();

            if (query.length < 2) {
                searchDropdown.classList.add('hidden');
                return;
            }

            searchTimeout = setTimeout(() => {
                fetch(`{{ route('clients.ajax_search') }}?term=${encodeURIComponent(query)}`)
                    .then(response => response.json())
                    .then(data => {
                        if (data.length > 0) {
                            searchDropdown.innerHTML = data.map(item => `
                                <a href="{{ url('admin/clients') }}/${item.cl_id}" 
                                   class="block px-6 py-4 hover:bg-emerald-50 border-b border-gray-100 last:border-b-0 transition duration-150 text-right">
                                    <div class="text-xl text-gray-900 font-bold">
                                        ${item.arabic_name} 
                                        <span class="text-gray-600 font-medium">
                                            (عضويه رقم: ${item.old_member_no})
                                        </span>
                                    </div>
                                </a>
                            `).join('');
                            searchDropdown.classList.remove('hidden');
                        } else {
                            searchDropdown.innerHTML = '<div class="px-6 py-4 text-gray-500 text-center text-lg italic">{{ __('No results found') }}</div>';
                            searchDropdown.classList.remove('hidden');
                        }
                    });
            }, 300);
        });

        // Close dropdown when clicking outside
        document.addEventListener('click', function(e) {
            if (!searchInput.contains(e.target) && !searchDropdown.contains(e.target)) {
                searchDropdown.classList.add('hidden');
            }
        });

        // Focus keyboard navigation
        searchInput.addEventListener('keydown', function(e) {
            if (e.key === 'Escape') searchDropdown.classList.add('hidden');
        });
    });
</script>
@endpush