@extends('layouts.admin')

@section('content')
    <div class="bg-white rounded-xl shadow-lg p-6" dir="rtl">
        {{-- Header --}}
        <div
            class="flex flex-col md:flex-row justify-between items-start md:items-center mb-6 gap-4 border-b border-gray-100 pb-6">
            <h2 class="text-2xl font-bold bg-gradient-to-r from-amber-600 to-orange-600 bg-clip-text text-transparent">
                {{ __('Edit Client') }} - {{ $client->arabic_name }}
            </h2>

            <div class="flex gap-2">
                <a href="{{ route('clients.show', $client->cl_id) }}"
                    class="inline-flex items-center gap-1 px-4 py-2 bg-gray-500 text-white rounded-lg hover:bg-gray-600 transition duration-150 shadow-sm">
                    <i class="entypo-back"></i>
                    <span>{{ __('Back') }}</span>
                </a>
                <button type="button" onclick="document.getElementById('editClientForm').submit()"
                    class="inline-flex items-center gap-1 px-4 py-2 bg-emerald-600 text-white rounded-lg hover:bg-emerald-700 transition duration-150 shadow-sm">
                    <i class="entypo-check"></i>
                    <span>{{ __('Update Client') }}</span>
                </button>
            </div>
        </div>

        <form id="editClientForm" action="{{ route('clients.update', $client->cl_id) }}" method="POST" class="space-y-8">
            @csrf

            {{-- Progress Status / Move Status --}}
            <div class="bg-amber-50 border border-amber-200 rounded-lg p-4 flex justify-between items-center">
                <div class="flex items-center gap-4">
                    <span class="font-bold text-amber-800">{{ __('Assignment Status') }}:</span>
                    <select name="move_status" id="move_status"
                        class="bg-white border border-amber-300 rounded px-3 py-1 text-sm focus:ring-2 focus:ring-amber-500 outline-none">
                        <option value="لا يوجد" {{ $client->move_status == 'لا يوجد' ? 'selected' : '' }}>{{ __('None') }}
                        </option>
                        <option value="متنازل" {{ $client->move_status == 'متنازل' ? 'selected' : '' }}>{{ __('Assignor') }}
                        </option>
                        <option value="متنازل اليه" {{ $client->move_status == 'متنازل اليه' ? 'selected' : '' }}>
                            {{ __('Assignee') }}
                        </option>
                        <option value="متنازل اليه و تنازل" {{ $client->move_status == 'متنازل اليه و تنازل' ? 'selected' : '' }}>{{ __('Both') }}</option>
                    </select>
                </div>

                <div class="flex gap-2">
                    <button type="button" id="openAssignmentBtn"
                        class="px-4 py-1.5 bg-orange-500 text-white rounded hover:bg-orange-600 shadow-sm transition">
                        {{ __('Assignment') }}
                    </button>
                </div>
            </div>

            <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-3 gap-6">
                {{-- Personal Info --}}
                <div class="space-y-4">
                    <h3 class="text-lg font-bold text-gray-800 border-r-4 border-emerald-500 pr-3">
                        {{ __('Personal Information') }}
                    </h3>

                    <div class="space-y-1">
                        <label class="text-sm font-medium text-gray-600">{{ __('Arabic Name') }}</label>
                        <input type="text" name="arabic_name" value="{{ $client->arabic_name }}"
                            class="w-full px-3 py-2 border border-gray-300 rounded-lg focus:ring-2 focus:ring-emerald-500 outline-none">
                    </div>

                    <div class="space-y-1">
                        <label class="text-sm font-medium text-gray-600">{{ __('English Name') }}</label>
                        <input type="text" name="english_name" value="{{ $client->english_name }}"
                            class="w-full px-3 py-2 border border-gray-300 rounded-lg focus:ring-2 focus:ring-emerald-500 outline-none"
                            dir="ltr">
                    </div>

                    <div class="space-y-1">
                        <label class="text-sm font-medium text-gray-600">{{ __('National ID') }}</label>
                        <input type="text" name="nat_id" value="{{ $client->nat_id }}"
                            class="w-full px-3 py-2 border border-gray-300 rounded-lg focus:ring-2 focus:ring-emerald-500 outline-none">
                    </div>

                    <div class="space-y-1">
                        <label class="text-sm font-medium text-gray-600">{{ __('Military Card') }}</label>
                        <input type="text" name="milit_card_id" value="{{ $client->milit_card_id }}"
                            class="w-full px-3 py-2 border border-gray-300 rounded-lg focus:ring-2 focus:ring-emerald-500 outline-none">
                    </div>
                </div>

                {{-- Contact Info --}}
                <div class="space-y-4">
                    <h3 class="text-lg font-bold text-gray-800 border-r-4 border-blue-500 pr-3">
                        {{ __('Contact Information') }}
                    </h3>

                    <div class="space-y-1">
                        <label class="text-sm font-medium text-gray-600">{{ __('Mobile') }}</label>
                        <input type="text" name="mobile" value="{{ $client->mobile }}"
                            class="w-full px-3 py-2 border border-gray-300 rounded-lg focus:ring-2 focus:ring-blue-500 outline-none">
                    </div>

                    <div class="space-y-1">
                        <label class="text-sm font-medium text-gray-600">{{ __('Address') }}</label>
                        <input type="text" name="address" value="{{ $client->address }}"
                            class="w-full px-3 py-2 border border-gray-300 rounded-lg focus:ring-2 focus:ring-blue-500 outline-none">
                    </div>

                    <div class="grid grid-cols-2 gap-4">
                        <div class="space-y-1">
                            <label class="text-sm font-medium text-gray-600">{{ __('Nationality') }}</label>
                            <input type="text" name="nationality" value="{{ $client->nationality }}"
                                class="w-full px-3 py-2 border border-gray-300 rounded-lg focus:ring-2 focus:ring-blue-500 outline-none">
                        </div>
                        <div class="space-y-1">
                            <label class="text-sm font-medium text-gray-600">{{ __('Gender') }}</label>
                            <select name="gender"
                                class="w-full px-3 py-2 border border-gray-300 rounded-lg focus:ring-2 focus:ring-blue-500 outline-none">
                                <option value="male" {{ $client->gender == 'male' ? 'selected' : '' }}>{{ __('Male') }}
                                </option>
                                <option value="female" {{ $client->gender == 'female' ? 'selected' : '' }}>{{ __('Female') }}
                                </option>
                            </select>
                        </div>
                    </div>

                    <div class="grid grid-cols-2 gap-4">
                        <div class="space-y-1">
                            <label class="text-sm font-medium text-gray-600">{{ __('City') }}</label>
                            <select name="city"
                                class="w-full px-3 py-2 border border-gray-300 rounded-lg focus:ring-2 focus:ring-blue-500 outline-none">
                                @foreach($cities as $city)
                                    <option value="{{ $city->id }}" {{ $client->city == $city->id ? 'selected' : '' }}>
                                        {{ $city->name }}
                                    </option>
                                @endforeach
                            </select>
                        </div>
                        <div class="space-y-1">
                            <label class="text-sm font-medium text-gray-600">{{ __('State') }}</label>
                            <select name="state"
                                class="w-full px-3 py-2 border border-gray-300 rounded-lg focus:ring-2 focus:ring-blue-500 outline-none">
                                @foreach($states as $st)
                                    <option value="{{ $st->id }}" {{ $client->state == $st->id ? 'selected' : '' }}>
                                        {{ $st->name }}
                                    </option>
                                @endforeach
                            </select>
                        </div>
                    </div>
                </div>

                {{-- Membership Info --}}
                <div class="space-y-4">
                    <h3 class="text-lg font-bold text-gray-800 border-r-4 border-purple-500 pr-3">
                        {{ __('Membership Information') }}
                    </h3>

                    <div class="grid grid-cols-2 gap-4">
                        <div class="space-y-1">
                            <label class="text-sm font-medium text-gray-600">{{ __('Member No') }}</label>
                            <input type="text" name="old_member_no" value="{{ $client->old_member_no }}"
                                class="w-full px-3 py-2 border border-gray-300 rounded-lg bg-gray-50 focus:ring-2 focus:ring-purple-500 outline-none">
                        </div>
                        <div class="space-y-1">
                            <label class="text-sm font-medium text-gray-600">{{ __('File No') }}</label>
                            <input type="text" name="file_no" value="{{ $client->file_no }}"
                                class="w-full px-3 py-2 border border-gray-300 rounded-lg focus:ring-2 focus:ring-purple-500 outline-none">
                        </div>
                    </div>

                    <div class="space-y-1">
                        <label class="text-sm font-medium text-gray-600">{{ __('Membership Type') }}</label>
                        <select name="member_type"
                            class="w-full px-3 py-2 border border-gray-300 rounded-lg focus:ring-2 focus:ring-purple-500 outline-none">
                            <option value="لا يوجد" {{ $client->member_type == 'لا يوجد' ? 'selected' : '' }}>{{ __('None') }}
                            </option>
                            <option value="ضابط دفاع جوى" {{ $client->member_type == 'ضابط دفاع جوى' ? 'selected' : '' }}>
                                {{ __('Air Defense Officer') }}
                            </option>
                            <option value="ضابط قوات مسلحه" {{ $client->member_type == 'ضابط قوات مسلحه' ? 'selected' : '' }}>
                                {{ __('Armed Forces Officer') }}
                            </option>
                            <option value="عضو دار الدفاع" {{ $client->member_type == 'عضو دار الدفاع' ? 'selected' : '' }}>
                                {{ __('Defense House Member') }}
                            </option>
                            <option value="منتفع" {{ $client->member_type == 'منتفع' ? 'selected' : '' }}>
                                {{ __('Beneficiary') }}
                            </option>
                            <option value="أقارب حتى الدرجه 3" {{ $client->member_type == 'أقارب حتى الدرجه 3' ? 'selected' : '' }}>{{ __('Relative up to 3rd degree') }}</option>
                            <option value="متوفى" {{ $client->member_type == 'متوفى' ? 'selected' : '' }}>{{ __('Deceased') }}
                            </option>
                        </select>
                    </div>

                    <div class="grid grid-cols-2 gap-4">
                        <div class="space-y-1">
                            <label class="text-sm font-medium text-gray-600">{{ __('Related To') }}</label>
                            <select name="related_to"
                                class="w-full px-3 py-2 border border-gray-300 rounded-lg focus:ring-2 focus:ring-purple-500 outline-none">
                                <option value="0">{{ __('None') }}</option>
                                @foreach($related_clients as $rel_cl)
                                    <option value="{{ $rel_cl->cl_id }}" {{ $client->related_to == $rel_cl->cl_id ? 'selected' : '' }}>{{ $rel_cl->arabic_name }}</option>
                                @endforeach
                            </select>
                        </div>
                        <div class="space-y-1">
                            <label class="text-sm font-medium text-gray-600">{{ __('Relation') }}</label>
                            <select name="relation"
                                class="w-full px-3 py-2 border border-gray-300 rounded-lg focus:ring-2 focus:ring-purple-500 outline-none">
                                @foreach($relations as $rel)
                                    <option value="{{ $rel->id }}" {{ $client->relation == $rel->id ? 'selected' : '' }}>
                                        {{ $rel->type }}
                                    </option>
                                @endforeach
                            </select>
                        </div>
                    </div>
                </div>
            </div>

            {{-- Financial Info --}}
            <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-3 gap-6 pt-6 border-t border-gray-100">
                <div class="space-y-1">
                    <label class="text-sm font-medium text-gray-600">{{ __('Bank Name') }}</label>
                    <input type="text" name="bank_name" value="{{ $client->bank_name }}"
                        class="w-full px-3 py-2 border border-gray-300 rounded-lg focus:ring-2 focus:ring-emerald-500 outline-none">
                </div>
                <div class="space-y-1">
                    <label class="text-sm font-medium text-gray-600">{{ __('Account Number') }}</label>
                    <input type="text" name="account_no" value="{{ $client->account_no }}"
                        class="w-full px-3 py-2 border border-gray-300 rounded-lg focus:ring-2 focus:ring-emerald-500 outline-none">
                </div>
                <div class="space-y-1">
                    <label class="text-sm font-medium text-gray-600">{{ __('Username') }}</label>
                    <input type="text" name="user_name" value="{{ $client->user_name }}"
                        class="w-full px-3 py-2 border border-gray-300 rounded-lg focus:ring-2 focus:ring-emerald-500 outline-none">
                </div>
            </div>

            <div class="space-y-1">
                <label class="text-sm font-medium text-gray-600">{{ __('Comment') }}</label>
                <textarea name="comment" rows="3"
                    class="w-full px-3 py-2 border border-gray-300 rounded-lg focus:ring-2 focus:ring-emerald-500 outline-none">{{ $client->comment }}</textarea>
            </div>
        </form>
    </div>

    {{-- Assignment Modal --}}
    <div id="assignmentModal" class="fixed inset-0 bg-black bg-opacity-50 z-50 flex items-center justify-center hidden">
        <div class="bg-white rounded-xl shadow-2xl w-full max-w-2xl overflow-hidden" dir="rtl">
            <div class="px-6 py-4 bg-orange-600 text-white flex justify-between items-center">
                <h3 class="text-xl font-bold">{{ __('Assignment Process') }}</h3>
                <button type="button" onclick="closeAssignmentModal()" class="text-white hover:text-gray-200">
                    <i class="entypo-cancel text-2xl"></i>
                </button>
            </div>

            <div class="p-6 space-y-6">
                {{-- Source Member Section --}}
                <div class="space-y-4 border-b border-gray-100 pb-6">
                    <h4 class="text-sm font-bold text-gray-800 uppercase tracking-wider">{{ __('Transfer From (Source)') }}
                    </h4>
                    <div class="space-y-2">
                        <label class="block text-xs font-medium text-gray-500">{{ __('Source Member No') }}</label>
                        <div class="flex gap-2">
                            <input type="text" id="source_member_no"
                                class="flex-1 px-3 py-2 border border-gray-300 rounded-lg focus:ring-2 focus:ring-orange-500 outline-none text-sm"
                                placeholder="{{ __('Search for giver...') }}">
                            <button type="button" onclick="searchSourceMember()"
                                class="px-4 py-2 bg-gray-800 text-white rounded-lg hover:bg-gray-900 transition shadow-sm text-sm">
                                {{ __('Search & Load Units') }}
                            </button>
                        </div>
                        <div id="source_member_info" class="text-sm font-bold text-orange-600"></div>
                        <input type="hidden" id="cl_id_from">
                    </div>

                    <div class="space-y-2">
                        <label class="block text-xs font-medium text-gray-500">{{ __('Select Units to Transfer') }}</label>
                        <div id="project_selection"
                            class="space-y-2 max-h-40 overflow-y-auto p-3 border border-gray-200 rounded-lg bg-gray-50">
                            <div class="text-gray-400 italic text-xs text-center py-4">
                                {{ __('Search for a member to see their units...') }}
                            </div>
                        </div>
                    </div>
                </div>

                {{-- Target Member Section --}}
                <div class="space-y-4 pt-2">
                    <h4 class="text-sm font-bold text-gray-800 uppercase tracking-wider">{{ __('Transfer To (Target)') }}
                    </h4>
                    <div class="space-y-2">
                        <label class="block text-xs font-medium text-gray-500">{{ __('Target Member No') }}</label>
                        <div class="flex gap-2">
                            <input type="text" id="target_member_no" value="{{ $client->old_member_no }}"
                                class="flex-1 px-3 py-2 border border-gray-300 rounded-lg focus:ring-2 focus:ring-emerald-500 outline-none text-sm"
                                placeholder="{{ __('Search for receiver...') }}">
                            <button type="button" onclick="searchTargetMember()"
                                class="px-4 py-2 bg-emerald-600 text-white rounded-lg hover:bg-emerald-700 transition shadow-sm text-sm">
                                {{ __('Verify Target') }}
                            </button>
                        </div>
                        <div id="target_member_info" class="text-sm font-bold text-emerald-600"></div>
                        <input type="hidden" id="cl_id_to">
                    </div>
                </div>
            </div>

            <div class="px-6 py-4 bg-gray-50 flex justify-end gap-3 border-t border-gray-100">
                <button type="button" onclick="closeAssignmentModal()"
                    class="px-4 py-2 text-gray-600 hover:text-gray-800 font-medium">
                    {{ __('Cancel') }}
                </button>
                <button type="button" id="confirmAssignmentBtn" disabled onclick="submitAssignment()"
                    class="px-6 py-2 bg-emerald-600 text-white rounded-lg hover:bg-emerald-700 disabled:opacity-50 disabled:cursor-not-allowed font-bold">
                    {{ __('Confirm Assignment') }}
                </button>
            </div>
        </div>
    </div>

@endsection

@push('scripts')
    <script>
        const moveStatus = document.getElementById('move_status');
        const openAssignmentBtn = document.getElementById('openAssignmentBtn');
        const assignmentModal = document.getElementById('assignmentModal');

        moveStatus.addEventListener('change', function () {
            if (this.value === 'متنازل' || this.value === 'متنازل اليه و تنازل') {
                openAssignmentBtn.classList.remove('hidden');
            } else {
                openAssignmentBtn.classList.add('hidden');
            }
        });

        // Initial check
        if (moveStatus.value === 'متنازل' || moveStatus.value === 'متنازل اليه و تنازل') {
            openAssignmentBtn.classList.remove('hidden');
        }

        openAssignmentBtn.addEventListener('click', function () {
            openAssignmentModal();
        });

        function openAssignmentModal() {
            assignmentModal.classList.remove('hidden');
            // Don't auto-load, wait for source search
        }

        function closeAssignmentModal() {
            assignmentModal.classList.add('hidden');
        }

        function searchSourceMember() {
            const memNo = document.getElementById('source_member_no').value.trim();
            const infoDiv = document.getElementById('source_member_info');
            const projectDiv = document.getElementById('project_selection');
            const clIdFromInput = document.getElementById('cl_id_from');

            if (!memNo) return;

            infoDiv.textContent = '{{ __("Searching & Loading...") }}';
            projectDiv.innerHTML = '<div class="text-center py-4 text-gray-500 italic">{{ __("Loading...") }}</div>';

            fetch(`{{ route('clients.ajax_search') }}?term=${memNo}`)
                .then(response => response.json())
                .then(data => {
                    const client = data.find(c => c.old_member_no == memNo || c.member_no == memNo || c.cl_id == memNo);
                    if (client) {
                        infoDiv.textContent = `✓ ${client.arabic_name}`;
                        clIdFromInput.value = client.cl_id; // Using internal cl_id
                        loadSourceProjects(client.cl_id);
                    } else {
                        infoDiv.textContent = '✖ {{ __("Source member not found") }}';
                        clIdFromInput.value = '';
                        projectDiv.innerHTML = '<div class="text-center py-4 text-gray-400 italic">{{ __("Search for a member to see their units...") }}</div>';
                    }
                })
                .catch(() => {
                    infoDiv.textContent = '✖ {{ __("Error searching") }}';
                });
        }

        function loadSourceProjects(clientId) {
            const projectDiv = document.getElementById('project_selection');

            // Construct URL dynamically since we don't have the giver's ID at compile time
            const url = `{{ url('admin/clients') }}/${clientId}/reservations-data`;

            fetch(url)
                .then(response => response.json())
                .then(data => {
                    const reservations = data.reservations || [];
                    projectDiv.innerHTML = '';
                    if (reservations.length === 0) {
                        projectDiv.innerHTML = '<div class="text-center py-4 text-gray-500">{{ __("No reservations found for this member") }}</div>';
                        return;
                    }

                    reservations.forEach(res => {
                        const label = `${res.project_name} - ${res.bldg_id}/${res.flat_num} (${res.flat_txt})`;
                        const val = JSON.stringify({
                            prj_id: res.prj_id,
                            bldg_id: res.bldg_id,
                            flat_num: res.flat_num
                        });
                        projectDiv.innerHTML += `
                                            <label class="flex items-center gap-3 p-2 hover:bg-white rounded transition cursor-pointer border border-transparent hover:border-gray-200">
                                                <input type="checkbox" name="target_projects[]" value='${val}' class="w-4 h-4 text-orange-600 rounded">
                                                <span class="text-sm font-medium text-gray-700">${label}</span>
                                            </label>
                                        `;
                    });
                });
        }

        function searchTargetMember() {
            const memNo = document.getElementById('target_member_no').value.trim();
            const infoDiv = document.getElementById('target_member_info');
            const confirmBtn = document.getElementById('confirmAssignmentBtn');
            const clIdToInput = document.getElementById('cl_id_to');

            if (!memNo) return;

            infoDiv.textContent = '{{ __("Verifying...") }}';

            fetch(`{{ route('clients.ajax_search') }}?term=${memNo}`)
                .then(response => response.json())
                .then(data => {
                    const client = data.find(c => c.old_member_no == memNo || c.member_no == memNo || c.cl_id == memNo);
                    if (client) {
                        infoDiv.textContent = `✓ ${client.arabic_name}`;
                        clIdToInput.value = client.cl_id; // Using internal cl_id
                        confirmBtn.disabled = false;
                    } else {
                        infoDiv.textContent = '✖ {{ __("Target member not found") }}';
                        clIdToInput.value = '';
                        confirmBtn.disabled = true;
                    }
                })
                .catch(() => {
                    infoDiv.textContent = '✖ {{ __("Error searching") }}';
                });
        }

        function submitAssignment() {
            try {
                console.log('submitAssignment triggered');

                const prjIds = Array.from(document.querySelectorAll('input[name="target_projects[]"]:checked')).map(cb => cb.value);
                const memFrom = document.getElementById('cl_id_from').value;
                const memTo = document.getElementById('cl_id_to').value;

                console.log('Parameters collected:', { prjIds, memFrom, memTo });

                if (!memFrom || !memTo || prjIds.length === 0) {
                    const errorMsg = 'Validation failed: From=' + memFrom + ', To=' + memTo + ', Count=' + prjIds.length;
                    console.error(errorMsg);
                    alert(errorMsg);
                    return;
                }

                console.log('Starting fetch to ' + '{{ route("clients.move_savings") }}');

                const btn = document.getElementById('confirmAssignmentBtn');
                btn.disabled = true;
                btn.textContent = '{{ __("Processing...") }}';

                const fetchUrl = '{{ route("clients.move_savings") }}';
                const csrfToken = '{{ csrf_token() }}';

                fetch(fetchUrl, {
                    method: 'POST',
                    headers: {
                        'Content-Type': 'application/json',
                        'Accept': 'application/json',
                        'X-CSRF-TOKEN': csrfToken
                    },
                    body: JSON.stringify({
                        id_from: memFrom,
                        id_to: memTo,
                        prj_ids: prjIds
                    })
                })
                    .then(response => {
                        console.log('Fetch response status:', response.status);
                        return response.json();
                    })
                    .then(data => {
                        console.log('Fetch response data:', data);
                        if (data.success) {
                            alert(data.message || '{{ __("Savings and units moved successfully") }}');
                            location.reload();
                        } else {
                            throw new Error(data.error || data.message || '{{ __("Unknown server error") }}');
                        }
                    })
                    .catch(err => {
                        console.error('Submit error details:', err);
                        alert('Error: ' + err.message);
                        btn.disabled = false;
                        btn.textContent = '{{ __("Confirm Assignment") }}';
                    });
            } catch (e) {
                console.error('JS Catch block caught:', e);
                alert('CRITICAL JS ERROR: ' + e.message);
            }
        }

        // AJAX submit for main form
        document.getElementById('editClientForm').addEventListener('submit', function (e) {
            e.preventDefault();

            const formData = new FormData(this);
            const data = Object.fromEntries(formData);

            fetch(this.action, {
                method: 'POST',
                headers: {
                    'Content-Type': 'application/json',
                    'Accept': 'application/json',
                    'X-CSRF-TOKEN': '{{ csrf_token() }}'
                },
                body: JSON.stringify(data)
            })
                .then(response => response.json())
                .then(data => {
                    if (data.success) {
                        window.location.href = '{{ route("clients.show", $client->cl_id) }}';
                    } else if (data.errors) {
                        let msg = '';
                        for (const [key, value] of Object.entries(data.errors)) {
                            msg += value + '\n';
                        }
                        alert(msg);
                    }
                });
        });
    </script>
@endpush