@extends('layouts.admin')

@section('title', 'Client Comments')

@section('header', 'Client History & Comments')

@section('content')
<div class="max-w-4xl mx-auto">
    
    <!-- Client Info -->
    <div class="glass-panel rounded-xl p-6 mb-8">
        <div class="flex items-center justify-between">
            <div>
                <h2 class="text-2xl font-bold text-gray-800">{{ $client->arabic_name ?? 'N/A' }}</h2>
                <div class="mt-2 flex items-center gap-4 text-sm text-gray-500">
                    <span class="bg-blue-100 text-blue-800 px-3 py-1 rounded-full">Old Member #: {{ $client->old_member_no }}</span>
                    <span class="bg-purple-100 text-purple-800 px-3 py-1 rounded-full">File #: {{ $client->file_no }}</span>
                </div>
            </div>
            <div class="text-right">
                <a href="{{ route('clients.delay_pay', $client->old_member_no) }}" class="text-primary hover:underline">View Financial Report</a>
            </div>
        </div>
    </div>

    <!-- Add New Comment Form -->
    <div class="bg-white rounded-xl shadow-sm border border-gray-100 p-6 mb-8">
        <h3 class="text-lg font-bold text-gray-700 mb-4">Add New Comment / Event</h3>
        <form action="{{ route('clients.comments.store') }}" method="POST">
            @csrf
            <input type="hidden" name="cl_id" value="{{ $client->cl_id }}">
            
            <div class="mb-4">
                <label class="block text-gray-700 text-sm font-bold mb-2">Comment Type</label>
                <div class="flex gap-4">
                    <label class="flex items-center cursor-pointer">
                        <input type="radio" name="flag" value="1" class="form-radio text-primary" checked>
                        <span class="ml-2 text-gray-700">General Note</span>
                    </label>
                    <label class="flex items-center cursor-pointer">
                        <input type="radio" name="flag" value="2" class="form-radio text-red-500">
                        <span class="ml-2 text-gray-700">Warning/Issue</span>
                    </label>
                    <label class="flex items-center cursor-pointer">
                        <input type="radio" name="flag" value="3" class="form-radio text-blue-500">
                        <span class="ml-2 text-gray-700">Call Log</span>
                    </label>
                </div>
            </div>

            <div class="mb-4">
                <label class="block text-gray-700 text-sm font-bold mb-2" for="comment">
                    Description
                </label>
                <textarea class="shadow appearance-none border rounded w-full py-2 px-3 text-gray-700 leading-tight focus:outline-none focus:shadow-outline focus:border-primary transition" 
                    id="comment" name="comment" rows="4" placeholder="Enter details here..."></textarea>
            </div>
            
            <div class="flex items-center justify-end">
                <button class="bg-primary hover:bg-emerald-600 text-white font-bold py-2 px-6 rounded-lg focus:outline-none focus:shadow-outline transition duration-200" type="submit">
                    Add Comment
                </button>
            </div>
        </form>
    </div>

    <!-- Timeline -->
    <div class="bg-white rounded-xl shadow-sm border border-gray-100 p-6">
        <h3 class="text-lg font-bold text-gray-700 mb-6 border-b pb-2">History</h3>
        
        <div class="space-y-8 relative before:absolute before:inset-0 before:ml-5 before:w-0.5 before:-translate-x-px before:bg-gradient-to-b before:from-gray-200 before:via-gray-100 before:to-transparent">
            @forelse($comments as $comment)
                <div class="relative flex items-start group">
                    <!-- Icon -->
                    <div class="absolute left-0 mt-1 h-10 w-10 flex items-center justify-center rounded-full border-4 border-white shadow-sm
                        @if($comment->flag == 2) bg-red-100 text-red-500
                        @elseif($comment->flag == 3) bg-blue-100 text-blue-500
                        @else bg-gray-100 text-gray-500 @endif">
                        @if($comment->flag == 2)
                            <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 9v2m0 4h.01m-6.938 4h13.856c1.54 0 2.502-1.667 1.732-3L13.732 4c-.77-1.333-2.694-1.333-3.464 0L3.34 16c-.77 1.333.192 3 1.732 3z"></path></svg>
                        @elseif($comment->flag == 3)
                            <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M3 5a2 2 0 012-2h3.28a1 1 0 01.948.684l1.498 4.493a1 1 0 01-.502 1.21l-2.257 1.13a11.042 11.042 0 005.516 5.516l1.13-2.257a1 1 0 011.21-.502l4.493 1.498a1 1 0 01.684.949V19a2 2 0 01-2 2h-1C9.716 21 3 14.284 3 6V5z"></path></svg>
                        @else
                            <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M8 10h.01M12 10h.01M16 10h.01M9 16H5a2 2 0 01-2-2V6a2 2 0 012-2h14a2 2 0 012 2v8a2 2 0 01-2 2h-5l-5 5v-5z"></path></svg>
                        @endif
                    </div>
                    
                    <div class="ml-16 w-full">
                        <div class="flex items-center justify-between mb-1">
                            <span class="text-sm font-semibold text-gray-900">
                                @if($comment->user == 0) System Admin @else {{ $comment->user }} @endif
                            </span>
                            <span class="text-xs text-gray-500">{{ \Carbon\Carbon::parse($comment->crdate)->format('M d, Y h:i A') }}</span>
                        </div>
                        <div class="bg-gray-50 p-4 rounded-lg text-gray-700 text-sm leading-relaxed border border-gray-100 shadow-sm">
                            {{ $comment->comment }}
                        </div>
                    </div>
                </div>
            @empty
                <div class="ml-16 text-gray-500 text-sm italic">No comments found. Start the conversation.</div>
            @endforelse
        </div>
    </div>
</div>
@endsection
