@extends('layouts.admin')

@section('content')
    <div class="max-w-6xl mx-auto space-y-6">
        <!-- Client Info Card -->
        <div class="bg-white rounded-2xl shadow-xl border border-blue-100 overflow-hidden">
            <div class="bg-gradient-to-r from-blue-600 to-indigo-600 p-6 flex justify-between items-center text-white">
                <div>
                    <h2 class="text-2xl font-bold">{{ __('Client Checks') }}</h2>
                    <p class="text-blue-50 text-sm mt-1">
                        <span class="font-bold">{{ $client->arabic_name }}</span>
                        <span class="mx-2 opacity-50">|</span>
                        {{ __('Membership No:') }} {{ $client->old_member_no }}
                    </p>
                </div>
                <div class="text-right">
                    <div class="text-xs uppercase tracking-widest text-blue-200 font-bold">{{ __('Total Checks') }}</div>
                    <div class="text-3xl font-black mt-1">{{ count($checks) }}</div>
                </div>
            </div>

            <div class="p-8">
                @if($checks->isEmpty())
                    <div class="py-20 text-center bg-gray-50 rounded-2xl border border-gray-100">
                        <i class="entypo-docs text-4xl text-gray-300 block mb-2"></i>
                        <span class="text-gray-400 italic">{{ __('No checks found for this client.') }}</span>
                    </div>
                @else
                    <div class="bg-white rounded-2xl border border-gray-100 overflow-hidden shadow-sm">
                        <table class="min-w-full divide-y divide-gray-200">
                            <thead class="bg-gradient-to-r from-gray-50 to-blue-50">
                                <tr class="text-xs font-bold text-gray-600 uppercase tracking-widest">
                                    <th class="px-6 py-4 text-left">{{ __('Check No.') }}</th>
                                    <th class="px-6 py-4 text-left">{{ __('Bank') }}</th>
                                    <th class="px-6 py-4 text-right">{{ __('Amount') }}</th>
                                    <th class="px-6 py-4 text-center">{{ __('Issue Date') }}</th>
                                    <th class="px-6 py-4 text-center">{{ __('Printed By') }}</th>
                                    <th class="px-6 py-4 text-center">{{ __('Actions') }}</th>
                                </tr>
                            </thead>
                            <tbody class="divide-y divide-gray-100 bg-white">
                                @foreach($checks as $check)
                                    <tr class="hover:bg-blue-50/30 transition-colors group">
                                        <td class="px-6 py-4">
                                            <div class="flex items-center">
                                                <i class="entypo-doc-text text-blue-500 mr-2 text-lg"></i>
                                                <span class="font-bold text-gray-800">{{ $check->bank_acc ?? 'N/A' }}</span>
                                            </div>
                                        </td>
                                        <td class="px-6 py-4">
                                            <div class="text-sm font-medium text-gray-700">{{ $check->bank ?? 'N/A' }}</div>
                                        </td>
                                        <td class="px-6 py-4 text-right">
                                            <div
                                                class="inline-flex items-center px-3 py-1 bg-emerald-50 border border-emerald-200 rounded-lg">
                                                <span
                                                    class="text-sm font-black text-emerald-700">{{ number_format($check->amount, 2) }}</span>
                                                <span class="text-xs text-emerald-600 ml-1">EGP</span>
                                            </div>
                                        </td>
                                        <td class="px-6 py-4 text-center">
                                            <div class="text-xs text-gray-500 font-medium">{{ $check->crdate ?? '-' }}</div>
                                        </td>
                                        <td class="px-6 py-4 text-center">
                                            <div
                                                class="text-xs text-gray-600 font-medium bg-gray-100 px-2 py-1 rounded inline-block">
                                                {{ $check->prn_by ?? '-' }}
                                            </div>
                                        </td>
                                        <td class="px-6 py-4">
                                            <div
                                                class="flex justify-center gap-2 opacity-0 group-hover:opacity-100 transition-opacity">
                                                <button class="p-2 text-blue-600 hover:bg-blue-50 rounded-lg transition-colors"
                                                    title="{{ __('View Details') }}">
                                                    <i class="entypo-eye"></i>
                                                </button>
                                                <button class="p-2 text-amber-600 hover:bg-amber-50 rounded-lg transition-colors"
                                                    title="{{ __('Edit') }}">
                                                    <i class="entypo-pencil"></i>
                                                </button>
                                                <button
                                                    class="p-2 text-red-600 hover:bg-red-50 rounded-lg transition-colors delete-check"
                                                    data-member="{{ $client->old_member_no }}" data-check="{{ $check->bank_acc }}"
                                                    title="{{ __('Delete') }}">
                                                    <i class="entypo-trash"></i>
                                                </button>
                                            </div>
                                        </td>
                                    </tr>
                                @endforeach
                            </tbody>
                        </table>
                    </div>
                @endif
            </div>
        </div>
    </div>

    <script>
        document.addEventListener('DOMContentLoaded', function () {
            const deleteButtons = document.querySelectorAll('.delete-check');

            deleteButtons.forEach(btn => {
                btn.addEventListener('click', function () {
                    const memberNo = this.dataset.member;
                    const checkNum = this.dataset.check;

                    if (!confirm('{{ __('Are you sure you want to delete this check?') }}')) {
                        return;
                    }

                    // Legacy style AJAX call (to match legacy system)
                    fetch('{{ url('admin/clients/delete-check') }}', {
                        method: 'POST',
                        headers: {
                            'Content-Type': 'application/json',
                            'X-CSRF-TOKEN': '{{ csrf_token() }}'
                        },
                        body: JSON.stringify({
                            old_member_no: memberNo,
                            chk_num: checkNum
                        })
                    })
                        .then(res => res.json())
                        .then(data => {
                            alert('{{ __('Check deleted successfully') }}');
                            location.reload();
                        })
                        .catch(err => {
                            alert('{{ __('Error deleting check') }}');
                            console.error(err);
                        });
                });
            });
        });
    </script>
@endsection