<?php
require 'vendor/autoload.php';
$app = require_once 'bootstrap/app.php';
$kernel = $app->make(Illuminate\Contracts\Console\Kernel::class);
$kernel->bootstrap();

use Illuminate\Support\Facades\DB;

try {
    echo "Dropping existing database...\n";
    DB::statement('DROP DATABASE IF EXISTS i6802603_teba');
    echo "✓ Database dropped\n\n";

    echo "Creating new database...\n";
    DB::statement('CREATE DATABASE i6802603_teba CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci');
    echo "✓ Database created\n\n";

    echo "Importing SQL file...\n";
    $sqlFile = 'd:\xampp\htdocs\admin_laravel\legacy_code\i6802603_teba.sql';

    if (!file_exists($sqlFile)) {
        die("ERROR: SQL file not found at: $sqlFile\n");
    }

    $sql = file_get_contents($sqlFile);

    // Switch to the new database
    DB::statement('USE i6802603_teba');

    // Import the SQL
    DB::unprepared($sql);

    echo "✓ SQL file imported successfully\n\n";

    // Verify by counting tables
    $tables = DB::select('SHOW TABLES');
    echo "Database now has " . count($tables) . " tables\n";

    echo "\n✅ Database replacement completed successfully!\n";

} catch (\Exception $e) {
    echo "❌ Error: " . $e->getMessage() . "\n";
    echo "\nStack trace:\n" . $e->getTraceAsString() . "\n";
}
