<?php
// raw_debug.php
$host = '127.0.0.1';
$db = 'admin_laravel';
$user = 'root';
$pass = ''; // Assuming standard XAMPP default
$charset = 'utf8mb4';

$dsn = "mysql:host=$host;dbname=$db;charset=$charset";
$options = [
    PDO::ATTR_ERRMODE => PDO::ERRMODE_EXCEPTION,
    PDO::ATTR_DEFAULT_FETCH_MODE => PDO::FETCH_ASSOC,
    PDO::ATTR_EMULATE_PREPARES => false,
];

try {
    $pdo = new PDO($dsn, $user, $pass, $options);
} catch (\PDOException $e) {
    // If localhost fails, try 'localhost' or socket? keeping simple for now.
    // XAMPP default is usually enough.
    echo "Connection failed: " . $e->getMessage();
    exit;
}

echo "--- Raw DB Debug ---\n";
try {
    $stmt = $pdo->query("SELECT count(*) as cnt FROM inst_table");
    $row = $stmt->fetch();
    echo "Total rows: " . $row['cnt'] . "\n";

    $stmt = $pdo->query("SELECT * FROM inst_table WHERE project = '3' LIMIT 5");
    $rows = $stmt->fetchAll();
    echo "Rows for project 3: " . count($rows) . "\n";
    foreach ($rows as $r) {
        print_r($r);
    }

    // Check for flat 48 specific
    $stmt = $pdo->query("SELECT * FROM inst_table WHERE project = '3' AND flat_type = '48'");
    $flatRows = $stmt->fetchAll();
    echo "Rows for flat 48: " . count($flatRows) . "\n";
    foreach ($flatRows as $r) {
        print_r($r);
    }

} catch (\PDOException $e) {
    echo "Query failed: " . $e->getMessage();
}
?>