<?php
require 'vendor/autoload.php';
$app = require_once 'bootstrap/app.php';
$kernel = $app->make(Illuminate\Contracts\Console\Kernel::class);
$kernel->bootstrap();

use Illuminate\Support\Facades\DB;

try {
    $tables = DB::select('SHOW TABLES');
    $all = [];
    foreach ($tables as $t) {
        $all[] = array_values((array) $t)[0];
    }

    $target = 'default_clients_check';
    echo "Exact match for $target: " . (in_array($target, $all) ? "YES" : "NO") . "\n";

    echo "Partial matches for 'inst' or 'installment':\n";
    foreach ($all as $t) {
        if (str_contains(strtolower($t), 'inst')) {
            echo " - $t\n";
        }
    }
} catch (\Exception $e) {
    echo "Error: " . $e->getMessage() . "\n";
}
