<?php
require 'vendor/autoload.php';
$app = require_once 'bootstrap/app.php';
$kernel = $app->make(Illuminate\Contracts\Console\Kernel::class);
$kernel->bootstrap();

use App\Models\InstallmentTable;
use Illuminate\Support\Facades\DB;

// IDs from user request
$projectId = 3;
$flatId = 48;

echo "--- Debugging Installments for Project $projectId, Flat $flatId ---\n";

// 1. Count Total
$count = InstallmentTable::count();
echo "Total rows in inst_table: $count\n";

// 2. Check for specific matches
$exactMatch = InstallmentTable::where('project', $projectId)
    ->where('flat_type', $flatId)
    ->count();
echo "Rows matching project=$projectId AND flat_type=$flatId: $exactMatch\n";

// 3. Check for partial matches (maybe string vs int issues)
$projMatch = InstallmentTable::where('project', $projectId)->count();
echo "Rows matching project=$projectId: $projMatch\n";

$flatMatch = InstallmentTable::where('flat_type', $flatId)->count();
echo "Rows matching flat_type=$flatId: $flatMatch\n";

// 4. Dump sample rows to see what data looks like
echo "\n--- Sample Data (First 5 rows) ---\n";
$samples = InstallmentTable::take(5)->get();
foreach ($samples as $s) {
    echo "ID: {$s->id} | Proj: '{$s->project}' | Flat: '{$s->flat_type}' | Amount: {$s->inst_amount}\n";
}

// 5. Check if headers are being saved correctly (first row imported might be header?)
$badRows = InstallmentTable::where('year', 'Year')->orWhere('month', 'Month')->get();
if ($badRows->count() > 0) {
    echo "\nWARNING: Found header rows in database!\n";
}
