<?php
// debug_inspection.php
require 'vendor/autoload.php';
$app = require_once 'bootstrap/app.php';
$kernel = $app->make(Illuminate\Contracts\Console\Kernel::class);
$kernel->bootstrap();

use App\Models\InstallmentTable;
use Illuminate\Support\Facades\DB;

$output = "";
$output .= "--- Debugging Data ---\n";

// 1. Check Project 3 (Loose check)
$rows = InstallmentTable::where('project', '3')->get();
$output .= "Rows with project='3': " . $rows->count() . "\n";

if ($rows->count() > 0) {
    $output .= "First 10 rows for Project 3:\n";
    foreach ($rows->take(10) as $r) {
        $output .= "ID: {$r->id}, Project: '[{$r->project}]', Flat Type: '[{$r->flat_type}]', Amount: {$r->inst_amount}\n";
    }

    // Check specific flat 48
    $flatRows = $rows->where('flat_type', '48');
    $output .= "\nRows matching flat_type='48' (Collection filter): " . $flatRows->count() . "\n";
} else {
    // Maybe project is "03" or " 3 "?
    $all = InstallmentTable::take(5)->get();
    $output .= "\nSample of ANY data in table:\n";
    foreach ($all as $r) {
        $output .= "ID: {$r->id}, Project: '[{$r->project}]', Flat Type: '[{$r->flat_type}]'\n";
    }
}

file_put_contents('debug_output.txt', $output);
echo "Debug complete. Check debug_output.txt\n";
