<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('default_temp_warnings', function (Blueprint $table) {
            $table->id('ser');
            $table->string('name', 150)->nullable();
            $table->string('mem_no', 50)->nullable();
            $table->string('area', 50)->nullable();
            $table->string('project', 150)->nullable();
            $table->string('total', 50)->nullable();
            $table->string('time_from', 10)->default('0');
            $table->string('time_to', 10)->default('0');
            $table->integer('prj_id')->default(0);
            $table->string('bldg', 11)->nullable();
            $table->string('flat_num', 100)->nullable();
            $table->integer('amount')->default(0);
            $table->integer('grand_amount')->default(0);

            $table->index('prj_id');
            $table->index('mem_no');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('default_temp_warnings');
    }
};
