<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('default_hr_audit', function (Blueprint $table) {
            $table->id();
            $table->integer('emp_id')->nullable();
            $table->string('type', 50);
            $table->string('reference_id', 50)->nullable();
            $table->text('snapshot')->nullable();
            $table->integer('reg_by')->nullable();
            $table->timestamp('created_at')->useCurrent();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('default_hr_audit');
    }
};
