<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('default_receipts', function (Blueprint $table) {
            $table->index(['prj_id', 'cl_id', 'flag'], 'idx_receipts_main');
            $table->index('rev_date', 'idx_receipt_date');
        });

        Schema::table('default_reservations', function (Blueprint $table) {
            $table->index(['prj_id', 'cl_id'], 'idx_resv_main');
            $table->index('flat_num', 'idx_resv_flat');
        });

        Schema::table('default_clients', function (Blueprint $table) {
            $table->index('old_member_no', 'idx_client_old_no');
            $table->index('member_no', 'idx_client_no');
            $table->index('flag', 'idx_client_flag');
        });

        Schema::table('default_employee', function (Blueprint $table) {
            $table->index('nat_id', 'idx_emp_nat_id');
            $table->index('flag', 'idx_emp_flag');
        });
    }

    public function down(): void
    {
        Schema::table('default_receipts', function (Blueprint $table) {
            $table->dropIndex('idx_receipts_main');
            $table->dropIndex('idx_receipt_date');
        });

        Schema::table('default_reservations', function (Blueprint $table) {
            $table->dropIndex('idx_resv_main');
            $table->dropIndex('idx_resv_flat');
        });

        Schema::table('default_clients', function (Blueprint $table) {
            $table->dropIndex('idx_client_old_no');
            $table->dropIndex('idx_client_no');
            $table->dropIndex('idx_client_flag');
        });

        Schema::table('default_employee', function (Blueprint $table) {
            $table->dropIndex('idx_emp_nat_id');
            $table->dropIndex('idx_emp_flag');
        });
    }
};
