<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('default_contractors', function (Blueprint $table) {
            $table->increments('cont_id');
            $table->string('arabic_name');
            $table->string('english_name')->nullable();
            $table->string('nat_id', 30)->nullable();
            $table->string('address')->nullable();
            $table->string('mobile', 20)->nullable();
            $table->string('comp_name')->nullable();
            $table->integer('prj_id')->nullable();
            $table->integer('reg_by')->nullable();
            $table->string('flag', 1)->default('Y');
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('default_contractors');
    }
};
