<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('default_park_inst', function (Blueprint $table) {
            $table->id();
            $table->integer('yr');
            $table->integer('mon');
            $table->decimal('inst_amount', 10, 2);
            $table->string('park_no')->nullable();
            $table->string('bldg_no')->nullable();
            $table->string('prj_id')->nullable();
            $table->string('date')->nullable();
            $table->string('yr_mon')->nullable();
            // No timestamps in legacy
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('default_park_inst');
    }
};
