<?php

namespace App\Services;

use Illuminate\Support\Facades\DB;

class ClientAccountService
{
    /**
     * Calculate comprehensive account report for a client
     * Migrated from legacy Cl_Account_rpt function
     * 
     * @param int $cl_id Client ID
     * @param int $prj_id Project ID
     * @return array Account calculation results
     */
    public function calculateAccountReport($cl_id, $prj_id = 2)
    {
        $filt = "(r.cl_id = '{$cl_id}' or c.cl_id = '{$cl_id}')";
        $join = "";

        if ($prj_id == '1') {
            $filt = "(r.cl_id = '{$cl_id}' or c.cl_id = '{$cl_id}') and res.flt_id != '0'";
            $join = "left join default_reservations res on (res.cl_id = c.member_no) and res.prj_id = r.prj_id";
        }

        // Get all receipts for this client and project
        $qry_r = "SELECT DISTINCT r.*, res.sess, res.subsess, t.type txt, c.old_member_no, c.arabic_name, 
                  res.flt_id, res.bldg_id, res.flat_num, f.txt ftxt, c.file_no, res.tot_inst,
                  res.garden, res.garden_size, res.park, res.park_count, res.roof, res.roof_size, c.member_no
                  FROM default_clients c
                  LEFT JOIN default_receipts r ON r.cl_id = c.cl_id
                  LEFT JOIN installment_type t ON t.id = r.type
                  LEFT JOIN default_reservations res ON (res.cl_id = c.member_no) AND res.prj_id = r.prj_id
                  LEFT JOIN flats f ON f.flt_id = res.flt_id
                  WHERE {$filt} AND r.flag = 'Y' AND c.flag = 'Y' AND r.prj_id = '{$prj_id}' 
                  AND r.type NOT IN ('200','100','96','99','98','111','7','8','101','999','9999','61','60','62') 
                  AND r.type IS NOT NULL
                  ORDER BY STR_TO_DATE(r.date, '%d-%m-%Y'), STR_TO_DATE(r.date, '%m-%d-%Y') ASC";

        $rows_r = DB::select($qry_r);

        $tot = 0;
        $park_tot = 0;
        $added_arr = [];
        $bl_no = 0;
        $fl_num = 0;
        $flt_id = 0;
        $final_inst = 0;
        $sess = null;
        $base_sess = null;

        // Additional fields from legacy logic
        $garden_size = 0;
        $cl_member_no = 0;
        $total_penality = 0;
        $park_flag = 'N';
        $park_count = 0;

        foreach ($rows_r as $row_r) {
            $sess = $row_r->sess ?? null;
            $base_sess = $sess;

            if (isset($row_r->subsess) && $row_r->subsess == '1') {
                $base_sess = '11';
            }

            if (!in_array($row_r->number, $added_arr) || $row_r->number == null || $row_r->number == '' || $row_r->number == '0') {
                if ($row_r->chk == 'N') {
                    $tot += $row_r->value;
                }
                if ($row_r->type == '3' && $row_r->chk == 'N') {
                    $park_tot += $row_r->value;
                }
                $added_arr[] = $row_r->number;
            }

            $fl_num = $row_r->flat_num ?? 0;
            $bl_no = $row_r->bldg_id ?? 0;
            $flt_id = $row_r->flt_id ?? 0;
            $final_inst = $row_r->tot_inst ?? 0;

            // Capture additional fields from the first row or loop (matches legacy logic)
            $garden_size = $row_r->garden_size ?? 0;
            $park_flag = $row_r->park ?? 'N';
            $park_count = $row_r->park_count ?? 0;
            $cl_member_no = $row_r->old_member_no;

            // In legacy loop: $cl_member_no = $row->member_no;
            // The query above selects c.member_no.
            if (isset($row_r->member_no)) {
                $cl_member_no = $row_r->member_no;
            }
        }

        // Calculate total penality (legacy loops through all rows)
        foreach ($rows_r as $row) {
            $total_penality += $row->penality ?? 0;
        }

        // Get parking, roof, garden payments
        $qry_r2 = "SELECT r.value, r.type tp FROM default_clients c
                   LEFT JOIN default_receipts r ON r.cl_id = c.cl_id
                   {$join}
                   WHERE {$filt} AND r.flag = 'Y' AND r.chk = 'N' AND c.flag = 'Y' 
                   AND r.prj_id = '{$prj_id}' AND r.type IN ('3','7','8') AND r.type IS NOT NULL
                   ORDER BY STR_TO_DATE(r.date, '%d-%m-%Y'), STR_TO_DATE(r.date, '%m-%d-%Y') ASC";

        $rows_r2 = DB::select($qry_r2);

        $opt_arr = [];
        foreach ($rows_r2 as $row_r) {
            if (!isset($opt_arr[$row_r->tp])) {
                $opt_arr[$row_r->tp] = [];
            }
            $opt_arr[$row_r->tp][] = $row_r->value;
        }

        // Get check totals
        $q = "SELECT * FROM default_receipts WHERE cl_id = '{$cl_id}' AND flag = 'Y' 
              AND ((type = '111' AND chk = 'Y')) AND prj_id IN ('{$prj_id}','0')";
        $rchk = DB::select($q);
        $tot_chk = 0;
        foreach ($rchk as $rc) {
            $tot_chk += $rc->value;
        }

        // Garden installments calculation
        $year = date('Y');
        $mon = date('m');
        if (strlen($mon) < 2) {
            $mon = '0' . $mon;
        }

        $gard_paid = isset($opt_arr['8']) ? array_sum($opt_arr['8']) : 0;
        $gard_total = 0;
        $late_gard_total = 0;

        $qr2 = "SELECT * FROM garden_inst_table WHERE prj_id = '{$prj_id}' 
                AND bldg_no = '{$bl_no}' AND flat_num = '{$fl_num}'";
        $rs2 = DB::select($qr2);

        $gard_inst = [];
        $late_gard_inst = [];
        foreach ($rs2 as $r2) {
            $key = "f{$r2->flat_num}";
            if (!isset($gard_inst[$r2->prj_id][$r2->bldg_no][$key])) {
                $gard_inst[$r2->prj_id][$r2->bldg_no][$key] = [];
                $late_gard_inst[$r2->prj_id][$r2->bldg_no][$key] = [];
            }

            $gard_inst[$r2->prj_id][$r2->bldg_no][$key][] = $r2->gard_inst_amount;

            $mons = ltrim(date('m'), "0");
            if ($r2->yr_mon <= date('Y') . $mons) {
                $late_gard_inst[$r2->prj_id][$r2->bldg_no][$key][] = $r2->gard_inst_amount;
            }
        }

        if (isset($gard_inst[$prj_id][$bl_no]["f{$fl_num}"])) {
            $gard_total = array_sum($gard_inst[$prj_id][$bl_no]["f{$fl_num}"]);
        }

        if (isset($late_gard_inst[$prj_id][$bl_no]["f{$fl_num}"])) {
            $late_gard_total = array_sum($late_gard_inst[$prj_id][$bl_no]["f{$fl_num}"]);
        }

        // Calculate biggest_total from installment table
        $biggest_total = $this->calculateBiggestTotal($prj_id, $flt_id, $fl_num, $bl_no, $sess, $base_sess, $year, $mon);
        $flat_aprox_total = $this->calculateFlatAproxTotal($prj_id, $flt_id, $fl_num, $bl_no, $sess, $base_sess);

        // Calculate parking installments (legacy logic from Prj_Rec2)
        $park_required = $this->calculateParkingInstallments($cl_member_no, $prj_id);

        // Calculate park_remain (Arrears) with legacy special case for Project 1
        $park_remain = 0;
        if ($prj_id == '1' && $park_flag == 'Y') {
            $park_remain = ((36000 * $park_count) - (int) $park_tot);
        } else {
            $park_remain = ($park_required - (int) $park_tot);
        }

        return [
            'fl_num' => $fl_num,
            'biggest_total' => $biggest_total,
            'flat_aprox_total' => $flat_aprox_total,
            'total' => $tot,
            'park_total' => $park_tot,
            'check' => $tot_chk,
            'tot_inst' => $final_inst,
            'remain' => (int) $biggest_total - (int) $tot,
            'gard_total' => $gard_total,
            'late_gard_total' => $late_gard_total,
            'gard_rem' => $gard_paid,
            'garden_size' => $garden_size, // Added
            'park_required' => $park_required, // Added
            'park_remain' => $park_remain, // Refined logic
        ];
    }

    /**
     * Calculate parking installments based on legacy Prj_Rec2 logic
     */
    private function calculateParkingInstallments($cl_member_no, $prj_id)
    {
        // Legacy logic:
        // $qry_park = "select * from default_park_resv where cl_id = '".$cl_member_no."' and prj_id = '".$prj_id."'";
        // Loop results, then query default_park_inst for each

        $park_resv = DB::table('default_park_resv')
            ->where('cl_id', $cl_member_no)
            ->where('prj_id', $prj_id)
            ->get();

        $parks_inst_sum = 0;
        $current_ym = date('Ym');
        $current_y = date('Y');

        foreach ($park_resv as $park) {
            // Check if default_park_inst table exists or use DB::table
            // Assuming table exists as per legacy code
            $inst_sum = DB::table('default_park_inst')
                ->where('bldg_no', $park->bldg)
                ->where('park_no', $park->park_no)
                ->where('prj_id', $park->prj_id)
                ->where(function ($query) use ($current_ym, $current_y) {
                    $query->where('yr_mon', '<=', $current_ym)
                        ->where('yr', '<=', $current_y);
                })
                ->sum('inst_amount');

            $parks_inst_sum += $inst_sum;
        }

        return $parks_inst_sum;
    }

    /**
     * Calculate the biggest total (amount due) from installment table
     */
    private function calculateBiggestTotal($prj_id, $flt_id, $fl_num, $bl_no, $sess, $base_sess, $year, $mon)
    {
        // Check if there are specific installments for this flat
        $rx_filter = "(flat_num = '{$fl_num}') AND (bldg_no = '{$bl_no}')";

        $qrx = "SELECT COUNT(id) cnt FROM inst_table 
                WHERE flat_type = '{$flt_id}' AND (flat_num = '{$fl_num}') 
                AND (bldg_no = '{$bl_no}') AND sess = '{$sess}' 
                AND yr_mon <= '{$year}{$mon}' AND project = '{$prj_id}'";

        $rsx = DB::select($qrx);
        $rx_cnt = $rsx[0]->cnt ?? 0;

        if ($rx_cnt == 0) {
            $rx_filter = "(flat_num = '{$fl_num}' OR flat_num = '' OR flat_num IS NULL) 
                         AND (bldg_no = '{$bl_no}' OR bldg_no = 0 OR bldg_no IS NULL OR bldg_no = '')";
        }

        $qr8 = "SELECT * FROM inst_table 
                WHERE flat_type = '{$flt_id}' AND sess IN ('{$base_sess}','{$sess}') 
                AND {$rx_filter} AND yr_mon <= '{$year}{$mon}' AND project = '{$prj_id}' 
                ORDER BY yr_mon DESC LIMIT 1";

        $rs8 = DB::select($qr8);
        $biggest_total = 0;

        foreach ($rs8 as $r) {
            $biggest_total = $r->total;
        }

        return $biggest_total;
    }

    /**
     * Calculate the approximate flat total (final price)
     */
    private function calculateFlatAproxTotal($prj_id, $flt_id, $fl_num, $bl_no, $sess, $base_sess)
    {
        $rx_filter = "(flat_num = '{$fl_num}') AND (bldg_no = '{$bl_no}')";

        $qrx = "SELECT COUNT(id) cnt FROM inst_table 
                WHERE flat_type = '{$flt_id}' AND (flat_num = '{$fl_num}') 
                AND (bldg_no = '{$bl_no}') AND sess = '{$sess}' AND project = '{$prj_id}'";

        $rsx = DB::select($qrx);
        $rx_cnt = $rsx[0]->cnt ?? 0;

        if ($rx_cnt == 0) {
            $rx_filter = "(flat_num = '{$fl_num}' OR flat_num = '' OR flat_num IS NULL) 
                         AND (bldg_no = '{$bl_no}' OR bldg_no = 0 OR bldg_no IS NULL OR bldg_no = '')";
        }

        $qr9 = "SELECT * FROM inst_table 
                WHERE flat_type = '{$flt_id}' AND sess IN ('{$base_sess}','{$sess}') 
                AND {$rx_filter} AND project = '{$prj_id}' 
                ORDER BY yr_mon DESC LIMIT 1";

        $rs9 = DB::select($qr9);
        $flat_aprox_total = 0;

        foreach ($rs9 as $r) {
            $flat_aprox_total = $r->total;
        }

        return $flat_aprox_total;
    }
}
