<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Reservation extends Model
{
    use HasFactory;
    protected $table = 'default_reservations';
    protected $primaryKey = 'resv_id';
    protected $fillable = ['garden', 'garden_size', 'cl_id', 'prj_id', 'flt_id', 'bldg_id', 'flat_num', 'floor', 'resv_date', 'resv_by'];
    public $timestamps = false;

    public function project()
    {
        return $this->belongsTo(Project::class, 'prj_id', 'prj_id');
    }

    public function flat()
    {
        return $this->belongsTo(Flat::class, 'flt_id', 'flt_id');
    }
}
