<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class PayOrder extends Model
{
    protected $table = 'default_pay_order';
    public $timestamps = false; // Legacy table doesn't have standard timestamps

    protected $guarded = [];

    protected $casts = [
        'issue_date' => 'datetime',
    ];

    public function project()
    {
        return $this->belongsTo(Project::class, 'prj_id', 'prj_id');
    }

    public function admin()
    {
        return $this->belongsTo(Admin::class, 'user', 'emp_id');
    }
}
