<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class HrAudit extends Model
{
    use HasFactory;

    protected $table = 'default_hr_audit';
    public $timestamps = false; // Using default CURRENT_TIMESTAMP for created_at

    protected $guarded = [];

    protected $casts = [
        'snapshot' => 'array',
    ];

    public function employee()
    {
        return $this->belongsTo(Employee::class, 'emp_id', 'emp_id');
    }

    public function registrar()
    {
        return $this->belongsTo(Admin::class, 'reg_by', 'id');
    }
}
