<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Employee extends Model
{
    use HasFactory;

    protected $table = 'default_employee';
    protected $primaryKey = 'emp_id';
    public $timestamps = false; // Legacy usually doesn't have standard timestamps or uses created_at only.

    protected $guarded = [];

    // Relationships can be added later (e.g., salaries, attendance)
    public function salaries()
    {
        return $this->hasMany(Salary::class, 'emp_id', 'emp_id');
    }

    public function attendance()
    {
        return $this->hasMany(Attendance::class, 'machine_id', 'emp_mach_id');
    }

    public function bonuses()
    {
        return $this->hasMany(Bonus::class, 'emp_id', 'emp_id');
    }

    public function vacations()
    {
        return $this->hasMany(Vacation::class, 'emp_id', 'emp_id');
    }
}
