<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Contractor extends Model
{
    protected $table = 'default_contractors';
    protected $primaryKey = 'cont_id';
    protected $guarded = [];

    public function payments()
    {
        return $this->hasMany(ContractorPayment::class, 'cont_id', 'cont_id');
    }

    public function project()
    {
        return $this->belongsTo(Project::class, 'prj_id', 'prj_id');
    }
}
