<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use App\Models\Project;

class Consultant extends Model
{
    protected $table = 'consultants';
    protected $primaryKey = 'cons_id';
    protected $guarded = [];

    public function project()
    {
        return $this->belongsTo(Project::class, 'prj_id', 'prj_id');
    }

    public function payments()
    {
        return $this->hasMany(ConsultantPayment::class, 'cons_id', 'cons_id');
    }
}
