<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Comment extends Model
{
    use HasFactory;

    protected $table = 'default_mem_comments';
    public $timestamps = false;

    protected $fillable = ['cl_id', 'mem_no', 'comment', 'flag', 'user', 'crdate'];

    public function client()
    {
        return $this->belongsTo(Client::class, 'cl_id', 'cl_id');
    }
}
