<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class Bank extends Model
{
    protected $table = 'banks';
    protected $primaryKey = 'bank_id';
    protected $guarded = [];
    public $timestamps = false;

    public function starts()
    {
        return $this->hasMany(BankStart::class, 'bank_id', 'bank_id');
    }

    public function details()
    {
        return $this->hasMany(BankDetail::class, 'bank_id', 'bank_id');
    }
}
