<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;

class WebsiteController extends Controller
{
    /**
     * Display client requests from website
     */
    public function clientRequests()
    {
        $requests = DB::table('default_transfer_aprv as t')
            ->leftJoin('default_clients as c', 't.cl_id', '=', 'c.cl_id')
            ->select('c.*', 't.type', 't.flag as tflag', 't.id as tid', 't.to_cl', 't.prj_id', 't.file_no as tfile_no')
            ->get();

        return view('admin.website.client_requests', compact('requests'));
    }

    /**
     * Display clients with comments
     */
    public function clientComments()
    {
        // Get clients who have registered on website with comments
        $clients = DB::table('default_clients_live')
            ->select('member_no as file_no', 'member_no as old_member_no', 'arabic_name')
            ->get();

        return view('admin.website.client_comments', compact('clients'));
    }

    /**
     * Display uploaded files from website
     */
    public function uploadedFiles()
    {
        $uploads = DB::table('default_rec_files as f')
            ->leftJoin('default_clients as c', 'c.old_member_no', '=', 'f.user_id')
            ->select('c.*', 'f.id as fid', 'f.filename', 'f.path', 'f.date_added')
            ->where('f.flag', '1')
            ->where('f.moved', '0')
            ->get();

        return view('admin.website.uploaded_files', compact('uploads'));
    }

    /**
     * Display area change requests
     */
    public function areaChangeRequests()
    {
        // Get area/unit change requests
        $requests = DB::table('default_move_requests')
            ->where('flag', '1')
            ->get();

        return view('admin.website.area_change_requests', compact('requests'));
    }

    /**
     * Display client data updates from website
     */
    public function clientUpdates()
    {
        // Get client profile updates from website
        $updates = DB::table('default_clients_live')
            ->get();

        return view('admin.website.client_updates', compact('updates'));
    }

    /**
     * Get comments for a specific client
     */
    public function getComments(Request $request)
    {
        $comments = DB::table('default_mem_comments')
            ->where('mem_no', $request->file_no)
            ->where('flag', '!=', '3')
            ->orderBy('id', 'asc')
            ->get();

        return response()->json(['comments' => $comments]);
    }

    /**
     * Reject a client request
     */
    public function rejectRequest(Request $request)
    {
        DB::table('default_transfer_aprv')
            ->where('id', $request->id)
            ->update(['flag' => '3']);

        return response()->json(['success' => true]);
    }
}
