<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;

class PrintController extends Controller
{
    /**
     * Empty Payment Order - Blank template
     */
    public function emptyPaymentOrder()
    {
        return view('admin.print.empty_payment_order');
    }

    /**
     * Manual Payment Order - Fillable form
     */
    public function manualPaymentOrder()
    {
        $banks = DB::table('banks')->get();
        $projects = DB::table('projects')->get();

        return view('admin.print.manual_payment_order', compact('banks', 'projects'));
    }

    /**
     * Print Checks - Bank selection
     */
    public function printChecks()
    {
        $banks = DB::table('banks')->get();

        return view('admin.print.print_checks', compact('banks'));
    }

    /**
     * Membership Form - Application form with CRUD
     */
    public function membershipForm()
    {
        // Fetch all membership requests
        $members = DB::table('default_req_member')->get();

        // Fetch states/cities for dropdown
        $states = [
            ['id' => '1', 'name' => 'القاهرة'],
            ['id' => '2', 'name' => 'الجيزة'],
            ['id' => '3', 'name' => 'الإسكندرية'],
            ['id' => '4', 'name' => 'الدقهلية'],
            ['id' => '5', 'name' => 'البحيرة'],
            ['id' => '6', 'name' => 'الفيوم'],
            ['id' => '7', 'name' => 'الغربية'],
            ['id' => '8', 'name' => 'الإسماعيلية'],
            ['id' => '9', 'name' => 'المنوفية'],
            ['id' => '10', 'name' => 'المنيا'],
            ['id' => '11', 'name' => 'القليوبية'],
            ['id' => '12', 'name' => 'الوادي الجديد'],
            ['id' => '13', 'name' => 'الشرقية'],
            ['id' => '14', 'name' => 'أسيوط'],
            ['id' => '15', 'name' => 'البحر الأحمر'],
            ['id' => '16', 'name' => 'بني سويف'],
            ['id' => '17', 'name' => 'بورسعيد'],
            ['id' => '18', 'name' => 'دمياط'],
            ['id' => '19', 'name' => 'الأقصر'],
            ['id' => '20', 'name' => 'سوهاج'],
            ['id' => '21', 'name' => 'جنوب سيناء'],
            ['id' => '22', 'name' => 'كفر الشيخ'],
            ['id' => '23', 'name' => 'مطروح'],
            ['id' => '24', 'name' => 'أسوان'],
            ['id' => '25', 'name' => 'شمال سيناء'],
            ['id' => '26', 'name' => 'السويس'],
            ['id' => '27', 'name' => 'قنا'],
        ];

        $genders = [
            ['id' => 'M', 'name' => 'ذكر'],
            ['id' => 'F', 'name' => 'أنثى'],
        ];

        return view('admin.print.membership_form', compact('members', 'states', 'genders'));
    }

    /**
     * Convert number to Arabic text
     */
    public function numberToText(Request $request)
    {
        $number = $request->input('number', 0);

        // Simple Arabic number conversion (you can use a library for more complex conversion)
        $ones = ['', 'واحد', 'اثنان', 'ثلاثة', 'أربعة', 'خمسة', 'ستة', 'سبعة', 'ثمانية', 'تسعة'];
        $tens = ['', 'عشرة', 'عشرون', 'ثلاثون', 'أربعون', 'خمسون', 'ستون', 'سبعون', 'ثمانون', 'تسعون'];
        $hundreds = ['', 'مائة', 'مائتان', 'ثلاثمائة', 'أربعمائة', 'خمسمائة', 'ستمائة', 'سبعمائة', 'ثمانمائة', 'تسعمائة'];

        if ($number == 0) {
            return response()->json(['text' => 'صفر جنيه مصري']);
        }

        // Simplified conversion - for production use a proper Arabic number library
        $text = number_format($number) . ' جنيه مصري';

        return response()->json(['text' => $text]);
    }
}
