<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;

class ImportController extends Controller
{
    /**
     * Display Excel import page
     */
    public function importTransactions()
    {
        return view('admin.import.import_transactions');
    }

    /**
     * Process single Excel row
     */
    public function processRow(Request $request)
    {
        try {
            $validated = $request->validate([
                'trans_date' => 'required',
                'val_date' => 'required',
                'trans_ref_no' => 'required',
                'desc' => 'nullable',
                'debit' => 'nullable|numeric',
                'credit' => 'nullable|numeric',
                'balance' => 'nullable|numeric',
            ]);

            // Insert into database
            DB::table('bank_transactions')->insert([
                'trans_date' => $validated['trans_date'],
                'val_date' => $validated['val_date'],
                'trans_ref_no' => $validated['trans_ref_no'],
                'desc' => $validated['desc'] ?? '',
                'debit' => $validated['debit'] ?? 0,
                'credit' => $validated['credit'] ?? 0,
                'balance' => $validated['balance'] ?? 0,
                'created_at' => now(),
            ]);

            return response()->json(['success' => true, 'message' => 'Row imported successfully']);
        } catch (\Exception $e) {
            return response()->json(['success' => false, 'message' => $e->getMessage()], 500);
        }
    }
}
