<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Models\Client;
use App\Models\Employee;
use App\Models\Contractor;
use App\Models\Consultant;

class GlobalSearchController extends Controller
{
    public function search(Request $request)
    {
        $term = $request->get('q');

        if (strlen($term) < 2) {
            return response()->json([]);
        }

        $results = [];

        // Search Clients
        $clients = Client::where('arabic_name', 'LIKE', "%{$term}%")
            ->orWhere('mobile', 'LIKE', "%{$term}%")
            ->limit(5)
            ->get();
        foreach ($clients as $c) {
            $results[] = [
                'title' => $c->arabic_name,
                'category' => 'Client',
                'url' => route('clients.index') . "?search=" . urlencode($c->arabic_name),
                'icon' => 'user'
            ];
        }

        // Search Employees
        $employees = Employee::where('arabic_name', 'LIKE', "%{$term}%")
            ->where('flag', 'Y')
            ->limit(5)
            ->get();
        foreach ($employees as $e) {
            $results[] = [
                'title' => $e->arabic_name,
                'category' => 'Employee',
                'url' => route('hr.index') . "?search=" . urlencode($e->arabic_name),
                'icon' => 'badge-check'
            ];
        }

        // Search Contractors
        $contractors = Contractor::where('arabic_name', 'LIKE', "%{$term}%")
            ->orWhere('comp_name', 'LIKE', "%{$term}%")
            ->where('flag', 'Y')
            ->limit(5)
            ->get();
        foreach ($contractors as $con) {
            $results[] = [
                'title' => $con->comp_name . " (" . $con->arabic_name . ")",
                'category' => 'Contractor',
                'url' => route('constr.show', $con->cont_id),
                'icon' => 'office-building'
            ];
        }

        // Search Consultants
        $consultants = Consultant::where('arabic_name', 'LIKE', "%{$term}%")
            ->orWhere('office_name', 'LIKE', "%{$term}%")
            ->where('flag', 'Y')
            ->limit(5)
            ->get();
        foreach ($consultants as $cons) {
            $results[] = [
                'title' => $cons->office_name . " (" . $cons->arabic_name . ")",
                'category' => 'Consultant',
                'url' => route('consult.show', $cons->cons_id),
                'icon' => 'academic-cap'
            ];
        }

        return response()->json($results);
    }
}
