<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Models\Bank;
use App\Models\BankStart;
use App\Models\BankDetail;
use App\Models\InOut;
use App\Models\ConsRec;
use App\Models\FinalStat;
use App\Models\Company;
use Illuminate\Support\Facades\DB;

class FinanceController extends Controller
{
    public function index()
    {
        return view('admin.finance.index');
    }

    public function banks()
    {
        $banks = Bank::whereIn('status', ['Y', 'V'])->get();
        return view('admin.finance.banks', compact('banks'));
    }

    public function incomeOutcome(Request $request)
    {
        $type = $request->get('type', 'income');
        $items = InOut::where('type', $type)->orderBy('id', 'desc')->get();
        $banks = Bank::whereIn('status', ['Y', 'V'])->get();
        return view('admin.finance.income_outcome', compact('items', 'type', 'banks'));
    }

    public function storeInOut(Request $request)
    {
        $request->validate([
            'item' => 'required',
            'value' => 'required|numeric',
            'type' => 'required',
        ]);

        InOut::create([
            'item' => $request->item,
            'value' => $request->value,
            'acc' => $request->acc,
            'chk_no' => $request->chk_no,
            'desc_date' => $request->desc_date,
            'crdate' => date("Y-m-d"),
            'yr' => date("Y"),
            'type' => $request->type,
            'name' => $request->name,
        ]);

        return back()->with('success', 'Record added successfully.');
    }

    public function deleteInOut($id)
    {
        InOut::findOrFail($id)->delete();
        return back()->with('success', 'Record deleted successfully.');
    }

    public function statements()
    {
        $companies = Company::all();
        $projects = DB::table('projects')->get();
        return view('admin.finance.statements', compact('companies', 'projects'));
    }
}
