<?php

namespace App\Http\Controllers;

use App\Models\Consultant;
use App\Models\ConsultantPayment;
use App\Models\Project;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;

class ConsultController extends Controller
{
    public function index()
    {
        $consultants = Consultant::with('project')
            ->where('flag', 'Y')
            ->get();
        return view('admin.consult.index', compact('consultants'));
    }

    public function create()
    {
        $projects = Project::where('flag', 'Y')->get();
        return view('admin.consult.create', compact('projects'));
    }

    public function store(Request $request)
    {
        $request->validate([
            'arabic_name' => 'required|string|max:255',
            'office_name' => 'nullable|string|max:255',
        ]);

        Consultant::create([
            'arabic_name' => $request->arabic_name,
            'english_name' => $request->english_name,
            'nat_id' => $request->nat_id,
            'address' => $request->address,
            'mobile' => $request->mobile,
            'office_name' => $request->office_name,
            'prj_id' => $request->prj_id,
            'reg_by' => Auth::guard('admin')->id(),
            'flag' => 'Y',
        ]);

        return redirect()->route('admin.consult.index')->with('success', 'Consulting office added successfully.');
    }

    public function show($id)
    {
        $consultant = Consultant::with(['project', 'payments'])->findOrFail($id);
        return view('admin.consult.show', compact('consultant'));
    }

    public function addPayment(Request $request, $id)
    {
        $request->validate([
            'amount' => 'required|numeric',
            'chk_date' => 'required',
            'chk_num' => 'required',
        ]);

        ConsultantPayment::create([
            'cons_id' => $id,
            'amount' => $request->amount,
            'chk_date' => $request->chk_date,
            'chk_num' => $request->chk_num,
            'flag' => 'Y',
        ]);

        return back()->with('success', 'Consultant payment recorded successfully.');
    }
}
