<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;

use App\Models\Contractor;
use App\Models\ContractorPayment;
use App\Models\Project;
use Illuminate\Support\Facades\Auth;

class ConstrController extends Controller
{
    public function index()
    {
        $contractors = Contractor::with('project')
            ->where('flag', 'Y')
            ->get();
        return view('admin.constr.index', compact('contractors'));
    }

    public function create()
    {
        $projects = Project::where('flag', 'Y')->get();
        return view('admin.constr.create', compact('projects'));
    }

    public function store(Request $request)
    {
        $request->validate([
            'arabic_name' => 'required|string|max:255',
        ]);

        Contractor::create([
            'arabic_name' => $request->arabic_name,
            'english_name' => $request->english_name,
            'nat_id' => $request->nat_id,
            'address' => $request->address,
            'mobile' => $request->mobile,
            'comp_name' => $request->comp_name,
            'prj_id' => $request->prj_id,
            'reg_by' => Auth::guard('admin')->id(),
            'flag' => 'Y',
        ]);

        return redirect()->route('admin.constr.index')->with('success', 'Contractor added successfully.');
    }

    public function show($id)
    {
        $contractor = Contractor::with(['project', 'payments'])->findOrFail($id);
        return view('admin.constr.show', compact('contractor'));
    }

    public function addPayment(Request $request, $id)
    {
        $request->validate([
            'amount' => 'required|numeric',
            'chk_date' => 'required',
            'chk_num' => 'required',
        ]);

        ContractorPayment::create([
            'cont_id' => $id,
            'amount' => $request->amount,
            'chk_date' => $request->chk_date,
            'chk_num' => $request->chk_num,
            'flag' => 'Y',
        ]);

        return back()->with('success', 'Payment recorded successfully.');
    }
}
