<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Hash;
use App\Models\Admin;

class AuthController extends Controller
{
    public function showLogin()
    {
        if (Auth::guard('admin')->check()) {
            return redirect()->route('admin.dashboard');
        }
        return view('auth.login');
    }

    public function login(Request $request)
    {
        $loginInput = $request->input('login');
        $password = $request->input('password');

        $request->validate([
            'login' => ['required', 'string'],
            'password' => ['required'],
        ]);

        $email = $loginInput;

        // If not a valid email, assume it's a username (prefix)
        if (!filter_var($loginInput, FILTER_VALIDATE_EMAIL)) {
            $adminByUsername = Admin::where('email', 'like', $loginInput . '@%')->first();
            if ($adminByUsername) {
                $email = $adminByUsername->email;
            }
        }

        $credentials = [
            'email' => $email,
            'password' => $password,
        ];

        // Attempt normal Laravel auth first (Bcrypt)
        if (Auth::guard('admin')->attempt($credentials)) {
            $request->session()->regenerate();
            return redirect()->intended(route('admin.dashboard'));
        }

        $admin = Admin::where('email', $email)->first();
        if ($admin) {
            $legacyHash = base64_encode($password);

            if ($admin->password === $legacyHash) {
                // Migrate to Bcrypt
                $admin->password = Hash::make($password);
                $admin->save();

                Auth::guard('admin')->login($admin);
                $request->session()->regenerate();
                return redirect()->intended(route('admin.dashboard'));
            }
        }

        return back()->withErrors([
            'login' => 'The provided credentials do not match our records.',
        ])->onlyInput('login');
    }

    public function logout(Request $request)
    {
        Auth::guard('admin')->logout();

        $request->session()->invalidate();
        $request->session()->regenerateToken();

        return redirect()->route('login');
    }
}
